/*
|============================================================================
|
|       Copyright (C) 2008-2011 ProSoft Technology. All rights reserved.
|
|  File:             datetimehelper.c
|
|  Class(es):        
|
|  Inherits From:    
|
|  Summary:          
|
|  Project(s):       PLX Utility
|
|  Subsystem:        Common
|
|  Contributors:     Henry Yu(HYU)
|
|  Description:      Date, Time, and RTC Helper functions for Linux
|
|  Notes:            This simple library contains function to simplify the
|                    Real Time Clock access
|
|============================================================================
|  Version     Date     Author  Change    Description
|----------------------------------------------------------------------------
|  Build     09/02/2011 HYU              Migrated to ProLinx Linux platform.
|============================================================================
*/
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <termios.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <linux/rtc.h> 
#include <time.h>
#include <sys/time.h>
#include "datetimehelper.h"





/*************************************************************************************************************                
/ Purpose: Function that writes the time to the RTC
/		
/ Params: struct tm: Time to write to the RTC
/
/ Returns: 0 if successful 
/          -1 on error
/ 
/ Comments:  
/
***********************************************************************************************************/
int setrtc(struct tm *time)
{
	int rtcfd = open("/dev/rtc0",O_RDWR);
	if (rtcfd<0) 
	{
		perror("Error Opening /dev/rtc0");
		return -1;
	}

	if (ioctl(rtcfd,RTC_SET_TIME,time)<0)
	{
		perror("Error in RTC_SET_TIME");
		close(rtcfd);
		return -1;
	}

	close(rtcfd);

	return 0;
}
