#ifndef load_and_parse_configuraiton_file_h
#define load_and_parse_configuraiton_file_h
#include <stdint.h>
#ifdef __cplusplus
extern "C"
{
#endif
	union tw_value_
	{
		int integerValue;
		float floatValue;
		char* stringValue;
	};

	enum plc_type
	{
		plc_type_INVALID = 0,
		plc_type_BOOL = 0xC1,
		plc_type_SINT = 0xC2,
		plc_type_INT = 0xC3,
		plc_type_DINT = 0xC4,
		plc_type_LINT = 0xC5,
		plc_type_USINT = 0xC6,
		plc_type_UINT = 0xC7,
		plc_type_UDINT = 0xC8,
		plc_type_ULINT = 0xC9,
		plc_type_REAL = 0xCA,
		plc_type_LREAL = 0xCB,
		plc_type_BYTE = 0xD1,
		plc_type_WORD = 0xD2,
		plc_type_DWORD = 0xD3,
		plc_type_LDWORD = 0xD4,
		plc_type_STRING82 = 0x0FCE,
		plc_type_NSTRING = 0x10001
	};

	union plc_value_union
	{
		char			int8_value;
		int16_t		int16_value;
		int32_t		int32_value;
		int64_t		int64_value;
		float			real32_value;
		double		real64_value;
		char			string_value[89]; // 4 bytes for length, 82 for value, one more - for terminating 0, and 2 additional - not clear way: TODO - find out.
	};

	typedef struct plc_value_
	{
		enum plc_type					type;
		union plc_value_union value;
	} plc_value;

	struct tw_property_aspect_
	{
		char* name;
		int type;
		union tw_value_ value;
		struct tw_property_aspect_* next;
	};
	typedef struct tw_property_aspect_ tw_property_aspect;

	struct tw_thing_property_
	{
		char* name;
		char* description;
		int		type;
		tw_property_aspect* aspects;
		struct tw_thing_property_* next;
	};
	typedef struct tw_thing_property_ tw_thing_property;

	struct tw_thing_
	{
		char* name;
		char* template_name;
		char* is_connected_property_name;
		tw_thing_property* properties;
		struct tw_thing_* next;
	};

	typedef struct tw_thing_ tw_thing;

	struct tw_server_config_
	{
		char*	hostname;
		int		port;
		int		use_https;
		int		disable_certificate_validation;
		uint32_t	timeout;
		int16_t		connection_retry_count;
		char*	app_key;
		char* path_to_root_ca_certificate_file;
		unsigned int polling_rate;
		tw_thing* things;
	};
	typedef struct tw_server_config_ tw_server_config;

	struct tw_http_server_
	{
		char*		host;
		int			port;
		char *	user_name;
		char*		password;
	};
	typedef struct tw_http_server_ tw_http_server;

	enum PlcTagAccessMode
	{
		PlcTagAccessMode_ReadOnly		= 0,
		PlcTagAccessMode_ReadWrite	= 1
	};

	struct tw_tag_
	{
		/* If both offset and tag name are defined, then offset is used and tag name is ignored. */
		
		/* If PLC supports only read/write tags by offset and length, then offset is used, and data length is determined based on data type. */
		uint16_t	offset;		
		
		/* If PLC allows read/write tags by name, then tag_name is used. */
		char*			tag_name;

		uint8_t   use_offset;

		enum plc_type		data_type;
		unsigned int		scan_rate;
		enum PlcTagAccessMode	access_mode;
		char*	thing;
		char* property_name;
  	void* tag_info;
		uint32_t poll_time;
		plc_value value; // Last read value.
		struct tw_tag_* next;
	};

	// Tag": "Alarm", "DataType": "BOOL", "ScanRate": "500", "Mode": "ReadOnly", "Thing": "SteamSensor", "Property": "FaultStatus"},
	typedef struct tw_tag_ tw_tag;

	struct tw_ldm_config_
	{
		tw_server_config	tw_server;
		tw_http_server		http_server;
		char*							plc_path;

		// Flag indicating if system time should be synchronized with PLC.
		// 0 - default value. Synchronize, if current system year is less than 2019. This will set system time once, after power recycling.
		// 1 - synchronize one time after first successful connection to the PLC. Even if system time was set, this will set it more precisely.
		// 2 - synchronize after every successful connection to the PLC. 
		int								sync_time_with_plc;
		
		/* Fields to read from output buffer of the PLC and write back to the input buffer. */
		/* Number of WORDs to read and write back. If 0, no read.wtite is performed. */
		uint16_t					plc_read_write_length;
		/* Offset of location to read data from Output Buffer. */
		uint16_t					plc_read_offset;
		/* Offset of location to write back data into Input Buffer. */
		uint16_t					plc_write_offset;
		/* Interval of read/write in milliseconds. Minimum is 1 ms. */
		uint16_t					plc_read_write_interval;

		uint32_t					status_print_interval; // Interval of printing status of connection with ThingWorx server, seconds. Default value is 10 seconds.
		int								get_tag_info_before_each_op; // If this option is true, tag into is retrieved from the PLC before each read/write operation, to make sure that data type is accurate.
		tw_tag*		tags;
	};
	typedef struct tw_ldm_config_ tw_ldm_config;
	
	void tw_ldm_free_config(tw_ldm_config* config);

	int load_and_parse_configuration_file(const char* path_to_file, tw_ldm_config* config);

#ifdef __cplusplus
}
#endif
#endif // load_and_parse_configuraiton_file_h
