/*
|============================================================================
|
|       Copyright (C) 2011-2012 ProSoft Technology. All rights reserved.
|
|  File:             PLXUtil.c
|
|  Class(es):        
|
|  Inherits From:    
|
|  Summary:          
|
|  Project(s):       PLX Utility
|
|  Subsystem:        Common
|
|  Contributors:     Henry Yu(HYU)
|
|  Description:      
|
|  Notes:            
|
|
|============================================================================
|  Version     Date     Author  Change    Description
|----------------------------------------------------------------------------
|  Build     8/23/2011 HYU              Created.
|           09/19/2011 HYU      Added getElapsedTime().
|           01/11/2012 HYU      Added ResetModule() and RestartModule().
|           10/02/2012 HYU      Added getElapsedTimeFrom().
|           11/16/2012 HYU      Added safe_snprintf().
|============================================================================
*/
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <sys/time.h>
#include <sys/sysinfo.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>

#include "ocxbpapi.h"

#include "plxdef.h"
#include "plxutil.h"
#include "moduleinfo.h"


// Refer to the plx-xxx module start script for more details
#define PLX_RESET_EXIT_CODE       1
#define PLX_RESTART_EXIT_CODE     0

#define PRODUCT_COPYRIGHT  "(c) 1999-2012 ProLinx Communication Gateways, Inc."


int GetModuleVersionInfo(char * verInfo, int len)
{
	MODULE_INFO mInfo;
    if (GetModuleInfo(&mInfo) != 0)
    {
        return -1;
    }

    snprintf(verInfo, len, "\n%s\n"
                      "     %s\n\n"
                      "     PRODUCT NAME CODE         : %s\n"
                      "     SOFTWARE REVISION LEVEL   : %s\n"
                      "     OPERATING SYSTEM REVISION : %s\n"
                      "     RUN NUMBER                : %s\n\n",
                      mInfo.ProductName,
                      PRODUCT_COPYRIGHT,
                      mInfo.ProductCode,
                      mInfo.ProductRev,
                      mInfo.OpRev,
                      mInfo.OpRun);

    return 0;
}

void ResetModule(void)
{
    exit(PLX_RESET_EXIT_CODE);
}

void RestartModule(void)
{
    exit(PLX_RESTART_EXIT_CODE);
}

long small2_clock(void)
{
	struct timeval time;

	// Get current Time of Day
	gettimeofday(&time,NULL);

	return time.tv_usec;
}

unsigned long timediff(unsigned long oldTime, unsigned long newTime)
{
	if (newTime > oldTime)
	{
		return newTime - oldTime;
	}
	else
	{
		return newTime + (TM_ROLLOVER - oldTime);
	}
}

// get the elapsed time in microseconds
long getElapsedTime(void)
{
    static long long lasttime = 0;
    return getElapsedTimeFrom(&lasttime);
}

long getElapsedTimeFrom( long long *lasttime )
{
    struct timespec ts;
    long long tnow, tlast = *lasttime;
    long elapsedTime;
    
    clock_gettime(CLOCK_MONOTONIC, &ts);
    //clock_gettime(CLOCK_REALTIME, &ts);
    
    // calculate the number of microseconds represented by the seconds
    tnow = ts.tv_sec;
    tnow *= 1000000L;
    
    // calculate the microseconds now
    tnow += (ts.tv_nsec / 1000L);
    
    if( !tlast )
    {
        *lasttime = tnow;
        return 0;
    }
    
    elapsedTime = tnow - tlast;
    
    *lasttime = tnow;
    
    return elapsedTime;
}

char * stolower( char * str )
{
    char* cp = str;
    // process the string
    for (; *cp != '\0'; cp++)
        *cp = tolower(*cp);
    return str;
}

int TrimRight(char *s)
{
    size_t len = strlen(s);
    while (len > 0 && isspace(s[len-1]))
    {
        --len;
    }
    
    s[len] = '\0';
    
    return len;
}

int safe_snprintf(char *str, unsigned int size, const char *format, ...)
{
    va_list ap;
    int ret;

	/* See http://www.ijs.si/software/snprintf/ for portable
	 * implementation of snprintf.
	 */

    va_start(ap, format);
    ret = vsnprintf(str, size, format, ap);
    va_end(ap);
    if (size > 0)
    {
        str[size - 1] = '\0';
        if ((int)size <= ret || ret < 0)
        {
            ret = size - 1;
        }
    }
    else if (str != NULL)
    {
        return 0;
    }
    
    return ret;
}

