/*
|============================================================================
|
|       Copyright (C) 2011 ProSoft Technology. All rights reserved.
|
|  File:             crc.c
|
|  Class(es):        
|
|  Inherits From:    
|
|  Summary:          
|
|  Project(s):       PLX Utility
|
|  Subsystem:        Common
|
|  Contributors:     Henry Yu(HYU)
|
|  Description:      
|
|  Notes:            
|
|
|============================================================================
|  Version     Date     Author  Change    Description
|----------------------------------------------------------------------------
|  Build     8/17/2011 HYU              Created.
|============================================================================
*/
#include "crc.h"


////////////////////////////////////////////////////////////
// LOCAL VARIABLES FOR CRC COMPUTATION
////////////////////////////////////////////////////////////

static unsigned short CRC16A[16] =
	{
		0x0000, 0xc0c1, 0xc181, 0x0140,
		0xc301, 0x03c0, 0x0280, 0xc241,
		0xc601, 0x06c0, 0x0780, 0xc741,
		0x0500, 0xc5c1, 0xc481, 0x0440
	};

static unsigned short CRC16B[16] =
	{
		0x0000, 0xcc01, 0xd801, 0x1400,
		0xf001, 0x3c00, 0x2800, 0xe401,
		0xa001, 0x6c00, 0x7800, 0xb401,
		0x5000, 0x9c01, 0x8801, 0x4400
	};


unsigned short CRC16(char * buff, int buff_len)
{
	unsigned short crc, temp;
	char * p = buff;
	int count = buff_len;

	crc = 0xffffU;

	while(count-- > 0)
	{
		temp = (unsigned int) (*p++) ^ crc;
		crc = (crc >> 8) ^ CRC16A[temp & 0x0f] ^ CRC16B[(temp & 0xf0) >> 4];
	}

	return crc;
}
