/*
|============================================================================
|
|       Copyright (C) 2012 ProSoft Technology. All rights reserved.
|
|  File:             sysutil.c
|
|  Class(es):        
|
|  Inherits From:    
|
|  Summary:          
|
|  Project(s):       PLX System Utility
|
|  Subsystem:        Common
|
|  Contributors:     Henry Yu(HYU)
|
|  Description:      
|
|  Notes:            
|
|
|============================================================================
|  Version     Date     Author  Change    Description
|----------------------------------------------------------------------------
|  Build     09/03/2011 HYU              Created.
|		 	 12/12/2012 PJB				 added rescue module
|============================================================================
*/
#include <sys/types.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/sysinfo.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdio.h>
#include <ctype.h>


#include "plxjumpers.h"
#include "sysutil.h"

#define  MAX_COPY_BUFFER  1024

/*****************************************************************************
 * Purpose: Function that orders the linux system to shutdown
 *
 * Params: Nothing
 *
 * Returns: 0 if OK
 *
 * Comments:
 *
 *
******************************************************************************/
int RebootSystem( void )
{
    signal(SIGCLD, SIG_IGN);  // now I don't have to wait()
    pid_t pid;

    switch(pid=fork()) {
        case -1: // Something went wrong
            perror("fork");
            return -1;
        case 0:  // this is the child process
            //sleep(2); // Wait so at least this page can be returned
            // In order to be able to do a shutdown the process has to be root
            // because the web server doesn't run as root, the suid bit has to be added
            // to the plx80upgrade
            setuid(geteuid());
            // Kill init process
            kill(1,SIGTERM);
            exit(0);
        default: // This is the parent process
            return 0;
    }
    return(1);
}

/*****************************************************************************
 * Purpose: Restores the module to the factory default state.
 *
 * Params: Nothing
 *
 * Returns: 0 if OK
 *
 * Comments:
 *
 *
******************************************************************************/
int RescueModule( void )
{
	int				result 		= -1;
	struct stat		file_stat;


	// make sure the setup jumper is installed.

	if ( inSetupMode() )
	{
		// make sure that the recover tar.gz is present and is a regular file
		if (  ( stat( BACKUP_SYSTEM_IMAGE, &file_stat ) != -1 )
		   && ( (file_stat.st_mode & S_IFMT) == S_IFREG ) )
		{
			// remove the startup scripts, since extras could be messing things up

			remove( ALL_INIT_SCRIPTS );

			// removed the prosoft update file, just in case it was left around.

			remove( PSFT_UPDATE_FILE );

			// execute a tar extraction

			system( BACKUP_SYSTEM_RESTORE_CMD );
		}
	}
	else
	{
	}

	return( result );
}

long getFreeMemSize()
{
	struct sysinfo si;
	sysinfo(&si);
	return (si.freeram);
}

int CopyFile(const char *fromFile, const char *toFile)
{
	unsigned char buff[MAX_COPY_BUFFER];
	int count;

	int fd = open(fromFile, O_RDONLY, 0666);
	if (fd == -1)
	{
		return -1;
	}

	int fd2 = open(toFile, O_CREAT | O_WRONLY | O_TRUNC | O_SYNC, 0666);
	if (fd2 == -1)
	{
		close(fd);
		return -1;
	}

	while ((count = read(fd, buff, sizeof(buff))) > 0)
	{
		write(fd2, buff, count);
		fchmod (fd2, 0644);
		fchmod (fd2, 0666);
		fsync(fd2);
	}

	close(fd);
	close(fd2);

	return 0;
}
