/////////////////////////////////////////////////////////////////////////////
// FILEPARS.H
//
// (c) 2000, Vital Computer Solutions, Richard A. Reynolds
//
//  DATE: 02/10/2000
//
//  This file is used to be included when the flash ROM parsing functions
//  are to be used.
//
//  MODIFIED:
//  10/25/2011 HYU - Added Record_gethex().
//  12/06/2011 HYU - Added File_GetInt16_Seek and File_GetInt32_Seek.
//
/////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

char * skiptonext(char * buff);
int Record_getval(char * buff);
int Record_gethex(char * buff);
unsigned long Record_getlong(char * buff);
char   Record_getchar(char * buff);
void   Record_getstr(char * buff, char * fbuff, int buffSize);
void   Record_getIP(char * buff, char * fbuff);

int File_Find_Section(FILE * fptr, char * SubSec);
char * File_GetString_Seek(FILE * fptr, long FLoc, char * Topic, char * buff);
unsigned short File_GetInt_Seek(FILE * fptr, long FLoc, char * Topic);
short File_GetInt16_Seek(FILE * fptr, long FLoc, char * Topic);
int File_GetInt32_Seek(FILE * fptr, long FLoc, char * Topic);
int File_GetPtr_Seek(FILE * fptr, long FLoc, char * Topic);
unsigned long File_GetLong_Seek(FILE * fptr, long FLoc, char * Topic);
unsigned char File_GetChar_Seek(FILE * fptr, long FLoc, char * Topic);
float File_GetFloat_Seek(FILE * fptr, long FLoc, char * Topic);
double File_GetDouble_Seek(FILE * fptr, long FLoc, char * Topic);
