#ifndef WATTCPEDIT_H_
#define WATTCPEDIT_H_

#include <sys/socket.h>
#include <netinet/in.h>
/////////////////////////////////////////////////////////////////
// Definitions
/////////////////////////////////////////////////////////////////
#define WATTCP_CFG_FILENAME  "/psft_conf/wattcp.cfg"

#ifdef __cplusplus
extern "C" {
#endif

#define HAS_IP_NETMASK    0x0001
#define HAS_IP_GATEWAY    0x0002

typedef struct
{
	int options;
	int ip[4];
	int netmask[4];
	int gateway[4];
} IpConfigData;

typedef struct
{
	char* ip;
	char* netmask;
	char* gateway;
} IpConfig;


#define IP_CFG_PORT1    0
#define IP_CFG_PORT2    1
#define IP_CFG_WLAN     2

typedef struct
{
    int type;
    char* ip;
    char* netmask;
    char* gateway;
} IpConfigEx;

/////////////////////////////////////////////////////////////////
// Function Prototypes
/////////////////////////////////////////////////////////////////
extern void networkDataToByteBuffer(char * buff, int *buff_len, int *ip, int *netmask, int *gateway);
extern void byteBufferToNetworkData(char * buff, int *ip, int *netmask, int *gateway);

extern int getConfigDateTime(char *commentLine, struct tm *configDateTime);

extern unsigned char getWattcpNetworkData(int *ip, int *netmask, int *gateway, struct tm *configDateTime);
extern unsigned char getWattcpNetworkDataEx(int *ip, int *netmask, int *gateway, struct tm *configDateTime, int type);
extern unsigned char setWattcpNetworkData(IpConfigData * configData, int numConfig);

extern int networkDataTo_in_addr(int *ip, struct in_addr *inAddr);

extern int setSystemNetworkData(char *ifname, int *ip, int *netmask, int *gateway);

extern int saveWattcpNetworkData(IpConfig * config, int numConfig);

extern int saveWattcpNetworkDataEx(IpConfigEx * config, int numConfig);

#ifdef __cplusplus
}
#endif
#endif /*WATTCPEDIT_H_*/

