#include "types-and-variables.h"
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

int tw_ldm_write_value(tw_tag* tag, plc_value* value)
{
	int								result;
	char							error_string[80];
	OCXCIPTAGACCESS*	tag_info;
	static int printed_init_error = 0;

	if (!PLC_DB_Initialized)
	{
		if (!printed_init_error)
		{
			printf("Read error: Tag database is not initialized\n");
			printed_init_error = 1;
		}
		return TW_LDM_DEVICE_NOT_CONNECTED;
	}
	if (!tag)
	{
		fprintf(stderr, "Function tw_ldm_write_value called with invalid argument \"tag\"\n");
		return -1;
	}
	if (!value)
	{
		fprintf(stderr, "Function tw_ldm_write_value called with invalid argument \"value\"\n");
		return -1;
	}
	printed_init_error = 0;
	if (!tag->tag_info)
	{
		tag->tag_info = malloc(sizeof(OCXCIPTAGACCESS));
		if (!tag->tag_info)
		{
			fprintf(stderr, "Failed to allocate memory for tag->tag_info\n");
			return -1;
		}
		memset(tag->tag_info, 0, sizeof(OCXCIPTAGACCESS));
		tag_info = (OCXCIPTAGACCESS*)tag->tag_info;
		tag_info->result = -1; // Not initialized yet.
	}
	tag_info = (OCXCIPTAGACCESS*)tag->tag_info;

	if (tag_info->result != 0 || gl_app_config.get_tag_info_before_each_op)
	{
		// get information on tag
		result = get_tag_info(tag->tag_name, tag_info);
		if (result != 0)
			return result;
		if (tag_info->daType != tag->data_type)
		{
			result = -1;
			fprintf(stderr, "Tag [%s]: configured data type [%d] is different than actual data type [%d]\n", tag->tag_name, tag->data_type, tag_info->daType);
			tag_info->result = result;
			return result;
		}
		tag_info->tagName = tag->tag_name;
		tag_info->opType = OCX_CIP_TAG_WRITE_OP;
		tag_info->numEle = 1;
	}

	if (tag_info->daType != value->type)
	{
		fprintf(stderr, "Tag [%s]: data type [%d] of the value to write is different than actual data type [%d]\n", tag->tag_name, value->type, tag_info->daType);
		return -1;
	}
	switch (value->type)
	{
	case plc_type_BOOL:
	case plc_type_BYTE:
	case plc_type_SINT:
	case plc_type_USINT:  // 1 byte
		tag_info->data = &value->value.int8_value;
		break;
	case plc_type_INT:    // 2 bytes
	case plc_type_UINT:
	case plc_type_WORD:
		tag_info->data = &value->value.int16_value;
		break;
	case plc_type_DINT:   // 4 bytes
	case plc_type_UDINT:
	case plc_type_DWORD:
		tag_info->data = &value->value.int32_value;
		break;
	case plc_type_LINT:   // 8 bytes
	case plc_type_ULINT:
	case plc_type_LDWORD:
		tag_info->data = &value->value.int64_value;
		break;
	case plc_type_REAL:   // 4 bytes
		tag_info->data = &value->value.real32_value;
		break;
	case plc_type_LREAL:
		tag_info->data = &value->value.real64_value;
		break;
	case plc_type_STRING82:
		tag_info->data = &value->value.string_value;
		break;
	default:
		return -1;
	}

	result = OCXcip_AccessTagData(OCX_Handle, gl_app_config.plc_path, DEFAULT_OCX_TIMEOUT, &tag_info, 1);
	if (result != OCX_SUCCESS)
	{
		OCXcip_ErrorString(result, error_string);
		printf("\nWrite tag data failed, result = [%d:%s]\n", result, error_string);
		tag_info->result = result; // This will force update of tag info next time.
		return result;
	}
	if (tag_info->result != OCX_SUCCESS)
	{
		OCXcip_ErrorString(tag_info->result, error_string);
		printf("\nFailed to write to individual tag [%s], result = [%d:%s] \n", tag->tag_name, tag_info->result, error_string);
		return tag_info->result;
	}
	return 0;
}
