/////////////////////////////////////////////////////////////////////////////
//
// PLXNet.h
//
// socket interface
//
// Copyright (c) 2011, ProSoft Technology, All Rights Reserved
//
//
// DATE     : Aug/08/2011
// MODIFIED :
// Aug/08/2011 HYU - Created
//  03/27/2012 PJB - Added SocketShutdown() and fixed prototypes
//  08/22/2012 HYU - Added the functions for UDP.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _PLXNET_H
#define _PLXNET_H

#include "plxdef.h"
#include <fcntl.h>
#include <sys/socket.h>


typedef int socket_t;

#define SocketOpen(D,T,P)	socket(D,T,P)
#define SocketBind(S,N,L)	bind(S,N,L)
#define SocketListen(S,B)	listen(S,B)
#define SocketAccept(S,N,L)	accept(S,N,L)
#define SocketClose(A)		close(A)
#define SocketShutdown(S)	shutdown(S,SHUT_RDWR)
#define SocketsLastError()  (errno)

#ifndef INVALID_SOCKET
#define INVALID_SOCKET      (socket_t)-1
#endif

#define SocketRead(S,B,L)   recv(S,B,L,0)

int SocketInit( void );
void SocketAbort(socket_t socket);
int SocketSend(socket_t s, const void *buf, int len);

socket_t SocketCreateListener(int port);
socket_t SocketAcceptConnection(socket_t listener_socket);
socket_t SocketCreateTcp( void );
socket_t SocketCreateTcp2( const char * ifname );
int SocketCreateConnection(socket_t sock, unsigned long ip, unsigned short port);

//flag bits for SocketSendUdp()
#define PLX_UDP_UNICAST              0x0000
#define PLX_UDP_BROADCAST            0x0001
#define PLX_UDP_MULTICAST            0x0002

int SocketCreateUdp(unsigned short port, const char *ifname, socket_t *sock_p);
int SocketSendUdp(socket_t sock, int flag, unsigned long ip, unsigned short port, const void *buf, int len);
int SocketReadUdp(socket_t sock, unsigned long *ip, unsigned short *port, char *buffer, int max_len);
int SocketJoinMulticast( socket_t sock, unsigned long addr );
int SocketDropMulticast( socket_t sock, unsigned long addr );


typedef struct
{
	fd_set   m_irfds; // Set that always contains what we're interested in.
	fd_set   m_iwfds;
	fd_set   m_iefds;
	fd_set   m_srfds; // Set that is passed to select.
	fd_set   m_swfds;
	fd_set   m_sefds;

	socket_t m_LastSocket;
	int        m_lastSocketIndex;
	int        m_socketCount;
	socket_t   m_socketArray[FD_SETSIZE];
} SOCKET_EVENT_MGR;

void se_wait_set(SOCKET_EVENT_MGR *netMgr, socket_t s);
void se_wait_clear(SOCKET_EVENT_MGR *netMgr, socket_t s);
inline int se_wait_read(SOCKET_EVENT_MGR *netMgr, socket_t s);
inline int se_wait_write(SOCKET_EVENT_MGR *netMgr, socket_t s);
int se_wait(SOCKET_EVENT_MGR *netMgr, DWORD dwTimeout);

#endif
