/*
 * backplane.h
 *
 *  Created on: Dec 27, 2012
 *      Author: pboldt
 */

#ifndef TAGS_H_
#define TAGS_H_

#include "ocxtagdb.h"

#define READDATASIZE       496     /* App-defined Connected Read Data Size in bytes*/
#define WRITEDATASIZE      500     /* App-defined Connected Write Data Size in bytes*/

#define BT_READ_MAX    250      /* word count */
#define BT_WRITE_MAX   250      /* word count */


typedef struct
{
	unsigned short rd_start;
	unsigned short rd_count;
	unsigned short rd_blk_max;

	unsigned short wr_start;
	unsigned short wr_count;
	unsigned short wr_blk_max;

	short rd_blk_next;
	short rd_blk_last;
	short wr_blk;

	unsigned short write_buff[BT_WRITE_MAX];
	unsigned short read_buff[BT_READ_MAX];

} BT_DATA;

extern BT_DATA       bt_data;


#endif /* TAGS_H_ */
