/*
|============================================================================
|
|       Copyright (C) 2012 ProSoft Technology. All rights reserved.
|
|  File:             cfgparse.h
|
|  Class(es):        
|
|  Inherits From:    
|
|  Summary:          
|
|  Project(s):       PLX Utility
|
|  Subsystem:        Common
|
|  Contributors:     Henry Yu(HYU)
|
|  Description:      Config file parser
|
|  Notes:            
|
|
|============================================================================
|  Version     Date     Author  Change    Description
|----------------------------------------------------------------------------
|  Build     08/26/2012 HYU              Created.
|============================================================================
*/
#ifndef _CFGPARSE_H
#define _CFGPARSE_H

#include <stdio.h>
#include "linklist.h"


#define MAX_CFG_LINE_LEN    256


typedef struct ConfigItem
{
    LL_DOUBLE_LINK_HEADER(ConfigItem);
    char line[MAX_CFG_LINE_LEN];
}ConfigItem;

typedef struct ConfigSection
{
    LL_DOUBLE_LINK_HEADER(ConfigSection);
    ConfigItem items;
}ConfigSection;


typedef struct ConfigParser ConfigParser;
struct ConfigParser
{
    FILE * fptr;
    char delimiter;
    LL_HEAD_NODE(ConfigSection) sectionList;
    ConfigSection * currentSection;
};

void ConfigParser_Init(ConfigParser * me, char delimiter);
void ConfigParser_Cleanup(ConfigParser * me);
int ConfigParser_LoadSection(ConfigParser * me, const char * fname, const char * sectionName);
int ConfigParser_Load(ConfigParser * me, const char * fname);
int ConfigParser_Save(ConfigParser * me, const char * fname);
int ConfigParser_Save2(ConfigParser * me, FILE *fptr);
int ConfigParser_SeekSection(ConfigParser * me, const char * sectionName);
char * ConfigParser_SeekItemGetValue(ConfigParser * me, const char * itemName);
int ConfigParser_ChangeItem(ConfigParser * me, const char * itemName, const char * val);
int ConfigParser_SeekItemGetChar(ConfigParser * me, const char * itemName, char * val);
int ConfigParser_SeekItemGetShort(ConfigParser * me, const char * itemName, short * val);
int ConfigParser_SeekItemGetWord(ConfigParser * me, const char * itemName, unsigned short * val);
int ConfigParser_SeekItemGetInt(ConfigParser * me, const char * itemName, int * val);
int ConfigParser_SeekItemGetLong(ConfigParser * me, const char * itemName, long * val);
int ConfigParser_SeekItemGetFloat(ConfigParser * me, const char * itemName, float * val);
int ConfigParser_SeekItemGetDouble(ConfigParser * me, const char * itemName, double * val);
int ConfigParser_AddItemString(ConfigParser * me, const char * itemName, const char * val);

#endif
