#!/bin/bash
#This script builds TW_LDM library for target MVI56E-LDM
# Folder where this script is located:
lib_ldm_script_dir=$(cd `dirname $0` && pwd)

ldm_build_folder=build/ldm/Release
root_dir=$lib_ldm_script_dir/../..
ldm_project_dir=$root_dir/ThingWorx-ldm-interface-lib
ldm_lib_dir=$ldm_project_dir/tw-ldm-interface-lib

if [ -d $ldm_project_dir/tw-ldm-interface-lib/src ]; then
if [ -d $root_dir/ThingWorx-edge-c-sdk/src ]; then

echo ""
echo "ThingWorx-LDM Interface lib source code folder and SDK headers are detected, building it."
echo ""

export PST_TOOLCHAIN_DIR="/opt/timesys/datm3/toolchain"
export PST_BUILD_DIR="$ldm_project_dir/$ldm_build_folder"
export THINGWORX_CSDK_OPENSSL_INCLUDE_DIR="$PST_TOOLCHAIN_DIR/include"

#Folder with libraries is not folder with actual files, it is temporary folder with symbolic links to real files:
export THINGWORX_CSDK_OPENSSL_LIB_DIR="$PST_BUILD_DIR/lib"

# If build folder does not exist, create it. Is exists, clean it:
pushd $ldm_project_dir
if [ -d $ldm_build_folder ]; then
rm -r $ldm_build_folder
fi
if ! [ -d $ldm_build_folder ]; then
mkdir -p $ldm_build_folder
fi
popd

pushd $PST_BUILD_DIR
echo "******** Building ThingWorx-LDM Interface Library with CMake **************"
echo "Current working folder is: $(pwd)"
cmake -DCMAKE_TOOLCHAIN_FILE=$lib_ldm_script_dir/LDM-toolchain.txt $ldm_lib_dir
echo "******** Building ThingWorx-LDM Interface Library with make ***************"
echo "Current working folder is: $(pwd)"

make

popd

else
echo ""
echo "ThingWorx-LDM Interface lib source code folder is not detected, not building it."
echo ""
fi
else
echo ""
echo "Folder [$root_dir/ThingWorx-edge-c-sdk/src] with header files not found, can not build interface library"
echo ""
fi

