#include "mvi69-types-and-variables.h"
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

int tw_ldm_write_value(tw_tag* tag, plc_value* value)
{
	int								result;
	char							error_string[80];
	static int printed_init_error = 0;
	WORD* buffer = NULL;
	uint16_t length = 0;

	if (!PLC_DB_Initialized)
	{
		if (!printed_init_error)
		{
			tw_ldm_log(TW_LDM_LOG_ERROR, "Write error: Not connected to the PLC");
			printed_init_error = 1;
		}
		return TW_LDM_DEVICE_NOT_CONNECTED;
	}
	if (!tag)
	{
		tw_ldm_log(TW_LDM_LOG_ERROR, "Function tw_ldm_write_value called with invalid argument \"tag\"");
		return -1;
	}
	if (!value)
	{
		tw_ldm_log(TW_LDM_LOG_ERROR, "Function tw_ldm_write_value called with invalid argument \"value\"");
		return -1;
	}

	if (!tag->use_offset)
	{
		tw_ldm_log(TW_LDM_LOG_ERROR, "Function tw_ldm_write_value called with invalid argument \"tag->use_offset\"");
		return -1;
	}

	switch (value->type)
	{
	case plc_type_BOOL:
	case plc_type_BYTE:
	case plc_type_SINT:
	case plc_type_USINT:  // 1 byte
		length = 1;
		buffer = &value->value.int8_value;
		break;
	case plc_type_INT:    // 2 bytes
	case plc_type_UINT:
	case plc_type_WORD:
		length = 2;
		buffer = &value->value.int16_value;
		break;
	case plc_type_DINT:   // 4 bytes
	case plc_type_UDINT:
	case plc_type_DWORD:
		length = 4;
		buffer = &value->value.int32_value;
		break;
	case plc_type_LINT:   // 8 bytes
	case plc_type_ULINT:
	case plc_type_LDWORD:
		length = 8;
		buffer = &value->value.int64_value;
		break;
	case plc_type_REAL:   // 4 bytes
		length = 4;
		buffer = &value->value.real32_value;
		break;
	case plc_type_LREAL:
		length = 8;
		buffer = &value->value.real64_value;
		break;
	case plc_type_STRING82:
		length = strlen(value->value.string_value);
		buffer = &value->value.string_value;
		break;
	default:
		return -1;
	}
	// write data back to controller input image
	length = (length + 1) / 2;
	result = MVI69_WriteInputImage(MVI69_Handle, tag->offset, length, buffer);

	if (result != MVI69_SUCCESS)
	{
		tw_ldm_log(TW_LDM_LOG_ERROR, "MVI69 Write Input Image failed: %d\n", result);
		return -1;
	}
	return 0;
}
