	TITLE	ALLOCSEG - First-Fit/Last-Fit Memory Allocation Test Program.

;***	ALLOCSEG - First-Fit/Last-Fit Memory Allocation Test Program.
;
;1.	Functional Description.
;	This program tests out INT 21h function 48h with both first fit
;	and last fit allocation strategies.
;
;2.	Modification History.
;	S. E. Jones	94/02/01.	#2.1.003, original.
;
;3.	NOTICE: Copyright (C) 1990-1994 General Software.
;
;4.	Build Environment.
;	MASM 5.10, no special switches.

	include ..\inc\usegs.inc
	include ..\inc\udefines.inc
	include ..\inc\umacros.inc
	include ..\inc\ustruc.inc

;	Define the stack.

_STACK	SEGMENT
	db	512 dup ('$')
TopStack =	$
_STACK	ENDS

UCODE	SEGMENT

;***	Main - Main Entrypoint.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is the entrypoint of the test program.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	all.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc Main, PUBLIC, FAR
	mov	ax, DGROUP
	mov	ds, ax
	ASSUME	DS:DGROUP		; (DS) = DGROUP.

;	Size this program down so we don't consume all of memory.
;	Note (ES) = seg FWA, PSP, for this call.

	mov	ah, 4ah                 ; (AH) = resize segment func code.
	mov	bx, 1024		; (BX) = paras to save (1024=>16KB).
	int	21h			; does the work.

;	Now start our test.

	PRINTF	<Allocating 100-paragraph segments...\n\n>
	mov	ah, 48h                 ; (AH) = allocate segment func code.
	mov	bx, 100                 ; (BX) = # paragraphs to allocate.
	int	21h
	jc	Main_Failure		; if we couldn't allocate the block.
	PRINTF	<Default strategy:   seg = $x\n>, <ax>
	mov	es, ax			; (ES) = segment to free.
	mov	ah, 49h                 ; (AH) = free segment function code.
	int	21h

;	Set FIRST FIT strategy.

	mov	ax, 5801h		; (AX) = set allocation method func code.
	mov	bx, 0			; (BX) = first fit strategy.
	int	21h			; SET FIRST FIT METHOD.

	mov	ah, 48h                 ; (AH) = allocate segment func code.
	mov	bx, 100                 ; (BX) = # paragraphs to allocate.
	int	21h
	jc	Main_Failure		; if we couldn't allocate the block.
	PRINTF	<First fit strategy: seg = $x\n>, <ax>
	mov	es, ax			; (ES) = segment to free.
	mov	ah, 49h                 ; (AH) = free segment function code.
	int	21h

;	Set LAST FIT strategy.

	mov	ax, 5801h		; (AX) = set allocation method func code.
	mov	bx, 2			; (BX) = last fit strategy.
	int	21h			; SET LAST FIT METHOD.

	mov	ah, 48h                 ; (AH) = allocate segment func code.
	mov	bx, 100                 ; (BX) = # paragraphs to allocate.
	int	21h
	jc	Main_Failure		; if we couldn't allocate the block.
	PRINTF	<Last fit strategy:  seg = $x\n>, <ax>
	mov	es, ax			; (ES) = segment to free.
	mov	ah, 49h                 ; (AH) = free segment function code.
	int	21h
	jmp	Main_Exit		; return successfully.

;	Error path goes here.

Main_Failure:
	PRINTF	<Unable to allocate 100 paragraphs of memory.\n>
	PRINTF	<Best size available: $u (0x$x) paragraphs.\n>, <bx, bx>

Main_Exit:
	mov	ax, 5801h		; (AX) = set allocation method func code.
	mov	bx, 0			; (BX) = first fit strategy.
	int	21h			; SET FIRST FIT METHOD.
	mov	ah, 4ch                 ; (AH) = terminate program func code.
	mov	al, 0			; successful status code.
	int	21h			; terminate program.
EndProc Main

UCODE	ENDS
	END	Main
