/*****************************************************************************
*
*   Title:        DF1 Full Duplex Definitions
*
*   Abstract:     This file contains definitions and declarations
*                 needed for developing applications which use the
*                 MVI API.
*
*
*   Environment:  MVI DF1 Full Duplex Module
*                 Borland/Microsoft C/C++ Compiler
*                 General Software Embedded DOS 6-XL
*
*   Author:       BJS
*                 Copyright (c) 2000 Online Development, Inc.
*
*****************************************************************************/

#ifndef _MVIFDAI_H
#define _MVIFDAI_H

/*---------------------------------------------------------
**  The MVI serial port API must be included.
**-------------------------------------------------------*/
#ifndef _MVISPAPI_H
#include "mvispapi.h"
#endif  /* ifndef _MVISPAPI */

/***********************************
**  DEFINITIONS
************************************/
#ifndef _MVIHDSAI_H						// If DF1 slave included, don't dup definitions
// DF1 port configuration definitions
#define 	DUP_PACKET_DIS		0x00	// Duplicate packet det disabled
#define 	DUP_PACKET_ENA		0x01	// Duplicate packet det enabled
#define		BCC_ERROR_CHK 		0x00	// Use BCC error checking									  
#define		CRC_ERROR_CHK 		0xFF	// Use CRC error checking
#define 	HSHAKE_CC			0x01	// Enable hardware handshake - continuous
										// carrier
#define		HSHAKE_NCC			0x02	// Enable hardware handshake - non-continuous
										// carrier
// MVI DF1 error codes
#define		MVI_ERR_NOSTAT		0x09	// Return error code which indicates
										// that there is no status data available
#define		MVI_ERR_NODATA		0X0A	// Return error code which indicates that
										// the function has no data to return
#define		MVI_ERR_OS			0X0B	// Return error code which indicates that
										// the OS was not able to initiate a thread,
										// event, or timer
#define 	MVIDF1_XMITTING		0X01	// Packet transmit error code that
										// indicates a packet is currently
										// queued and is attempting to be
										// transmitted.
#define		MVIDF1_SUCCESS		0X02	// Packet transmit error code that
										// indicates the packet has been
										// successfully xmitted
#define		MVIDF1_FAILED		0X03	// Packet transmit error code that
										// indicates xmission of the packet
										// failed
#define		MVI_RESP_VALID 		0x03	// A valid response packet has been received
#define		MVI_RESP_TIMEOUT 	0X01	// A response packet was not received within
// Diagnostic counter access numbers
#define 	PACKETS_RCVD 		0x00	// Total packets received
#define		BAD_CRC_BCC 		0x03	// Total packets with bad error check values
#define		DUPS_RCVD 			0x04	// Total number of duplicate packets received
#define		PACKETS_XMITTED 	0x05	// Total number of packets transmitted
#define		SINK_FULL 			0x06 	// Total rejected packets for full sink buffer
#define		SOURCE_FULL 		0x07	// Total rejected packets for full source buffer
#define		MESSAGE_RETRIES 	0x08	// Total number of message retries


#endif  /* ifndef _MVIHDSAI_H */
#define		HSHAKE_YES			0x02	// Enable hardware handshake - non-continuous
										// carrier 

/************************************
**  STRUCTURES
*************************************/

// This is the port configuration data structure.  
typedef struct tagFDCFG
{
    BYTE Baud;                  		// Desired baud rate
	BYTE Parity;						// Desired parity
	BYTE Stop;							// Desired stop bits
    BYTE DupPacket;             		// Duplicate packet detection enable/disable
    BYTE ErrorDet;        				// CRC or BCC error checking selection
    BYTE Station;          				// Station address. Range: 0-254;255 = broadcast
    BYTE Max_NAKS;           			// The maximum number of NAKS to be received in
    									// response to a transmitted message. 
	BYTE Max_ENQS;						// The maximum number of enquiries to be issued
										// after an ACK timeout.
    BYTE Handshake;           			// Hardware handshake control;
    									// 	HSHAKE_NONE =none
    									//  HSHAKE_YES = handshake enabled 
	WORD RTSSend;						// The RTS send delay in increments of 1 mS
	WORD RTSOff;						// The RTS off delay in	increments of 1 mS
	WORD ACKTimeout;					// The amount of time to wait for an
										// acknowledement (DLE-ACK, DLE-NAK)
										// to a transmitted message.
										// Units are in increments of 1 mS.
	BYTE MsgApplTimeout;				// The amount of time the to wait for a 
										// reply message in response to a command. Units
										// are in increments of seconds.
    int  ComPort;               		// Set to COM1 or COM2 or COM3
}FDCFG;
// This is the source-transmit-status data structure.  Data returned from the API call
// MVIdf1_FDGetPktStat will follow this format.
typedef struct tagSRCXMT
{
	BYTE Src;							// Source address of application
										// layer packet
	BYTE Cmd;							// Command value of application
										// layer packet
	WORD TNS;							// TNS count for application layer
										// packet
	BYTE XmitStatus;					// Transmit status of the application
										// packet
}SRCXMT;
// This is the sink-response-status data structure.  Data returned from the API call
// MVIdf1_FDGetRespPkt will follow this format.
typedef struct tagRSPRCV				//
{
	BYTE Src;							// Source address of received response packet
	BYTE Cmd;							// Command value of received response packet
	WORD TNS;							// TNS count for response packet
	BYTE RespStatus;					// Receive status of the response packet
}RSPRCV;
/************************************
**  VERSION INFORMATION STRUCT
*************************************/
typedef struct tagMVIFDVERSIONINFO
{
    WORD    APISeries;
    WORD    APIRevision;
} MVIFDVERSIONINFO;

/*************************************
**  API FUNCTION PROTOTYPES
*************************************/

MVIAPIENTRY MVIdf1_FDPutPkt(BYTE,BYTE *,WORD *);
MVIAPIENTRY MVIdf1_FDOpenPort(FDCFG *);
MVIAPIENTRY MVIdf1_FDGetPktStat(BYTE,SRCXMT *);
MVIAPIENTRY MVIdf1_FDGetDiagnostics(BYTE,WORD *,BYTE,BYTE);
MVIAPIENTRY MVIdf1_FDClosePort(BYTE);
MVIAPIENTRY MVIdf1_FDGetPkt(BYTE,BYTE *,WORD *,RSPRCV *);
MVIAPIENTRY MVIdf1_FDGetVersionInfo(MVIFDVERSIONINFO *);

#endif
