/*****************************************************************************
*
*   Title:        DF1 Half Duplex Master Definitions
*
*   Abstract:     This file contains definitions and declarations
*                 needed for developing applications which use the
*                 MVI API.
*
*
*   Environment:  MVI DF1 Half Duplex Master Module
*                 Borland/Microsoft C/C++ Compiler
*                 General Software Embedded DOS 6-XL
*
*   Author:       BJS
*                 Copyright (c) 2000 Online Development, Inc.
*
*****************************************************************************/

#ifndef _MVIHDMAI_H
#define _MVIHDMAI_H

/*---------------------------------------------------------
**  The MVI serial port API must be included.
**-------------------------------------------------------*/
#ifndef _MVISPAPI_H
#include "mvispapi.h"
#endif  /* ifndef _MVISPAPI */

/***********************************
**  DEFINITIONS
************************************/
#ifndef _MVIHDSAI_H						// If DF1 slave included, don't dup definitions
// DF1 port configuration definitions
#define 	DUP_PACKET_DIS		0x00	// Duplicate packet det disabled
#define 	DUP_PACKET_ENA		0x01	// Duplicate packet det enabled
#define		BCC_ERROR_CHK 		0x00	// Use BCC error checking									  
#define		CRC_ERROR_CHK 		0xFF	// Use CRC error checking
#define 	HSHAKE_CC			0x01	// Enable hardware handshake - continuous
										// carrier
#define		HSHAKE_NCC			0x02	// Enable hardware handshake - non-continuous
										// carrier
// MVI DF1 error codes
#define		MVI_ERR_NOSTAT		0x09	// Return error code which indicates
										// that there is no status data available
#define		MVI_ERR_NODATA		0X0A	// Return error code which indicates that
										// the function has no data to return
#define		MVI_ERR_OS			0X0B	// Return error code which indicates that
										// the OS was not able to initiate a thread,
										// event, or timer
#define 	MVIDF1_XMITTING		0X01	// Packet transmit error code that
										// indicates a packet is currently
										// queued and is attempting to be
										// transmitted.
#define		MVIDF1_SUCCESS		0X02	// Packet transmit error code that
										// indicates the packet has been
										// successfully xmitted
#define		MVIDF1_FAILED		0X03	// Packet transmit error code that
										// indicates xmission of the packet
										// failed
// Diagnostic counter access numbers
#define 	PACKETS_RCVD 		0x00	// Total packets received
#define		BAD_CRC_BCC 		0x03	// Total packets with bad error check values
#define		DUPS_RCVD 			0x04	// Total number of duplicate packets received
#define		PACKETS_XMITTED 	0x05	// Total number of packets transmitted
#define		SINK_FULL 			0x06 	// Total rejected packets for full sink buffer
#define		SOURCE_FULL 		0x07	// Total rejected packets for full source buffer
#define		MESSAGE_RETRIES 	0x08	// Total number of message retries
// This is the source-transmit-status data structure.  Data returned from the API call
// MVIdf1_HDMGetPktStat will follow this format.
typedef struct tagSRCXMT
{
	BYTE Src;							// Source address of application
										// layer packet
	BYTE Cmd;							// Command value of application
										// layer packet
	WORD TNS;							// TNS count for application layer
										// packet
	BYTE XmitStatus;					// Transmit status of the application
										// packet
}SRCXMT;


#endif  /* ifndef _MVIHDSAI_H */

// Master specific definitions
#define		MSG_NO_SLAVE_ALLD	0x00	// Message based polling, no slave initiated
#define		MSG_SLAVE_ALLD		0x01	// Message based polling, slave initiated allowed
#define		STD_SINGLE			0x02	// Standard polling, single responses
#define		STD_MULTIPLE		0x03	// Standard polling, multiple responses
#define		MVI_RESP_VALID 		0x03	// A valid response packet has been received
#define		MVI_RESP_TIMEOUT 	0X01	// A response packet was not received within
/************************************
**  STRUCTURES
*************************************/

// This is the port configuration data structure.  
typedef struct tagHDMCFG
{
    BYTE Baud;                  		// Desired baud rate
	BYTE Parity;						// Desired parity
	BYTE Stop;							// Desired stop bits
    BYTE DupPacket;             		// Duplicate packet detection enable/disable
    BYTE ErrorDet;        				// CRC or BCC error checking selection
    BYTE Station;          				// Station address. Range: 0-254;255 = broadcast
    BYTE MsgRetries;           			// Number of times a single message or enquiry will
										// be transmitted to a slave before being marked as
										// undeliverable.
    BYTE Handshake;           			// Hardware handshake control;
    									// 	HSHAKE_NONE =none 
										// 	HSHAKE_NCC =half-dup,w/o continuous carrier
										// 	HSHAKE_CC =half-dup,with continuous carrier
	WORD RTSSend;						// The RTS send delay in increments of 1 mS
	WORD RTSOff;						// The RTS off delay in	increments of 1 mS
	WORD ReplyMsgWait;					// The amount of time the master will wait after
										// receiving an ACK(to a master-initiated message)
										// before polling the slave for a reply. Units are
										// in increments of 1 mS. This is applicable only
										// for one of the message based polling modes
	WORD ACKTimeout;					// The amount of time the master will wait for an
										// acknowledement (DLE-ACK, DLE-EOT or a response
										// packet) to a transmitted message or an inquiry.
										// Units are in increments of 1 mS.
	BYTE MsgApplTimeout;				// The amount of time the master will wait for a 
										// reply message in response to an enquiry. Units
										// are in increments of seconds.
	BYTE PollingMode;					// The polling method to use:
										// 	MSG_NO_SLAVE_ALLD = Message based, no slave
										//			slave initiated messages allowed.
										// 	MSG_SLAVE_ALLD = Message vased, slave
										//			messages are allowed.
										// 	STD_SINGLE = Standard, single response message
										//			to an enquiry.
										// 	STD_MULTIPLE = Standard, multiple responses
										//			to an enquiry.
	WORD PreSend;						// The pre-send delay in 1 mS increments. This delay
										// precedes the RTSSend delay and therefore occurs
										// prior to the raising of the RTS signal.
	BYTE Norm_Poll_Low_Addr;			// The Normal Polling Range Low Address.
	BYTE Norm_Poll_High_Addr;			// The Normal Polling Range High Address.
	BYTE Norm_Poll_Group_Size;			// The number of active nodes in the normal poll list to
										// be polled before returning to poll all nodes in the
										// priority poll list.
	BYTE Priority_Poll_Low_Addr; 		// The Priority Polling Range Low Address.
	BYTE Priority_Poll_High_Addr;		// The Priority Polling Range High Address.
    int  ComPort;               		// Set to COM1 or COM2 or COM3
}HDMCFG;
// This is the sink-response-status data structure.  Data returned from the API call
// MVIdf1_HDMGetRespPkt will follow this format.
typedef struct tagRSPRCV				//
{
	BYTE Src;							// Source address of received response packet
	BYTE Cmd;							// Command value of received response packet
	WORD TNS;							// TNS count for response packet
	BYTE RespStatus;					// Receive status of the response packet
}RSPRCV;
/************************************
**  VERSION INFORMATION STRUCT
*************************************/
typedef struct tagMVIHDMVERSIONINFO
{
    WORD    APISeries;
    WORD    APIRevision;
} MVIHDMVERSIONINFO;

/*************************************
**  API FUNCTION PROTOTYPES
*************************************/

MVIAPIENTRY MVIdf1_HDMPutPkt(BYTE,BYTE *,WORD *);
MVIAPIENTRY MVIdf1_HDMOpenPort(HDMCFG *);
MVIAPIENTRY MVIdf1_HDMGetPktStat(BYTE,SRCXMT *);
MVIAPIENTRY MVIdf1_HDMGetDiagnostics(BYTE,WORD *,BYTE,BYTE);
MVIAPIENTRY MVIdf1_HDMClosePort(BYTE);
MVIAPIENTRY MVIdf1_HDMGetRespPkt(BYTE,BYTE *,WORD *,RSPRCV *);
MVIAPIENTRY MVIdf1_HDMGetVersionInfo(MVIHDMVERSIONINFO *);
#endif