;***	ACB.INC -- Embedded DOS Anchor Control Block.
;
;1.	Functional Description.
;	This structure defines the layout of the DOS-compatible anchor
;	block, or "list of lists", as it is referred to in the literature.
;	This structure is used in GLOBALS.INC to contain the major pointers
;	to structures managed by the executive.
;
;	Many DOS programs actually find this structure by calling INT 21h,
;	function 52h, to glean information about the system they are running
;	on.  One of the most popular things to do is to find the address of
;	the System File Table (SFT) and find the entries for CON and AUX,
;	subtract their addresses, and obtain the size of an SFT entry.	This
;	can be used as a sanity check to make sure that the program is running
;	on a specific version of DOS.  Windows 3.0 does this during init time.
;	While Embedded DOS doesn't use a DOS SFT, it builds a fake one so that
;	these programs can work.  The ACB is provided for the same reason.
;
;	It should be known that the ACB is not supported by Microsoft.	It
;	is an internal structure to DOS that changes on a version-to-version
;	basis, and its format is not published by Microsoft.  The excellent
;	and definitive reference source on this structure is the Addison-
;	Wesley title, Undocumented DOS, by Andrew Schulman, Raymond J. Michels,
;	Jim Kyle, Tim Paterson, David Maxey, and Ralf Brown.
;
;2.	Modification History.
;	S. E. Jones	91/03/08.	Original for 1.081.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

ACB		struc

;	The following fields are supported in versions 2.x, 3.x, and 4.x.

acb_dpblist	dd	?		; FWA, 1st drive parameter block in chain.
acb_sftlist	dd	?		; FWA, 1st SFT in chain.
acb_clockdev	dd	?		; FWA, CLOCK$ device driver header.
acb_condev	dd	?		; FWA, CON device driver header.

;	The following fields are specific to DOS 3.1-3.3.

acb_blocksize	dw	?		; maximum sector size in system.
acb_buflist	dd	?		; FWA, 1st disk buffer in chain.
acb_cdstbl	dd	?		; FWA, current directory string array.
acb_fcbtbl	dd	?		; FWA, FCB table.
acb_nprotfcbs	dw	?		; number of protected FCB's.
acb_nblkdev	db	?		; number of block devices.
acb_lastdrive	db	?		; LASTDRIVE= value (default is 5).
acb_nulhdr	db	18 dup (?)	; the actual NUL device driver header.
acb_njoindrives db	?		; number of joined drives.

ACB		ends
