;***	DEVHDR.INC -- Embedded DOS Device Driver Header.
;
;1.	Functional Description.
;	This structure defines the layout of the driver header in an
;	installable or system device driver.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/07/26.	#1.087, added EDEVHDR.
;	S. E. Jones	92/01/06.	#1.095, added BIGDISK, removed PARTIAL.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

DEVHDR		struc
devhdr_fwdlink	dd	?		; far FWA, next device driver in system.
devhdr_attr	dw	?		; device driver attributes.
devhdr_strat	dw	?		; code offset, strategy entrypoint.
devhdr_intr	dw	?		; code offset, interrupt entrypoint.
devhdr_name	db	8 dup (?)	; name of file system.
DEVHDR		ends

;	Device driver header attributes.

DEVATR_CHAR	=	8000h		; device is a character device.
DEVATR_IOCTL	=	4000h		; device can handle IOCTL read/write calls.
DEVATR_NONIBMBLK=	2000h		; block device, but non-IBM format.
DEVATR_OUTBUSY	=	2000h		; OVERLOADS!, output_until_busy supported.
DEVATR_EXTENDED =	1000h		; if set, this is an EDEVHDR.
DEVATR_OPNCLS	=	0800h		; open/close supported (3.x only).
DEVATR_V32	=	0040h		; generic IOCTL, get/set log drive supported.
DEVATR_INT29	=	0010h		; supports fast CON handler (int 29h).
DEVATR_CLOCK	=	0008h		; device is CLOCK.
DEVATR_NUL	=	0004h		; device is NUL.
DEVATR_BIGDISK	=	0002h		; block device uses 32-bit sector numbers.
DEVATR_CONOUT	=	0002h		; char device is console output.
DEVATR_CONIN	=	0001h		; char device is console input.

;	The following structure defines the layout of an extended device
;	header (Embedded DOS-specific) that is present only if the driver sets
;	the DEVATR_EXTENDED bit in its devhdr_attr field.  This allows us
;	to extend this header without breaking compatibility with MS-DOS.

EDEVHDR         struc
		db	(SIZE DEVHDR) dup (?) ; standard device header.
edevhdr_flags	dw	?		; extended capabilities.
edevhdr_resv	db	32 dup (0)	; reserved for future use, must be 0's.
EDEVHDR         ends

;	The following flags define the extended capabilities of the driver.
;	The MT and MP capabilities are related; if you set MP, you must set
;	MT, and that implies that all MP-safe drivers must be MT-safe as well.

EDEVHDR_FLAGS_SYNCH	=	0001h	; synchronous execution supported.
EDEVHDR_FLAGS_MT	=	0002h	; driver is MT-safe (multiple threads).
EDEVHDR_FLAGS_MP	=	0004h	; driver is MP-safe (multiple processors).
