//***	SDTE.H -- System Drive Table Entry Structure for C FSD Implementations.
//
//1.	Functional Description.
//	This include file contains structure definitions for use by
//	file system drivers (FSDs) that need access to drives in C.
//
//2.	Modification History.
//	S. E. Jones	93/03/14.	#1.101, original.
//	S. E. Jones	93/09/26.	#2.000, release.
//	S. E. Jones	95/01/24.	#2.2, release.
//
//3.	NOTICE: Copyright (C) 1993-1995 General Software, Inc.

#ifndef _SDTE
#define _SDTE

//
// This structure defines the layout of a File System Request Packet,
// used as the basic control block to pass to FSD drivers.
//

#define SDTE_DIRLEN	127		// len (directory string) < 128.
#define SDTE_SIGNATURE	0x1234		// if ==, this is an SDTE.

typedef struct _SDTE {
    USHORT sdte_sig;			// SDTE signature.
    USHORT sdte_flags;			// flags, see below.

#define SDTE_FLAGS_FSDDEFINED 0x0001	// FSD field is meaningful.
#define SDTE_FLAGS_DEVDEFINED 0x0002	// DEV field is meaningful.
#define SDTE_FLAGS_LOCKED     0x0004	// SDTE is locked. read/write not permitted.
#define SDTE_FLAGS_PREFIX     0x0008	// sdte_prefix is valid.
#define SDTE_FLAGS_NETWORK    0x0010	// set if drive is remoted on a network.

    USHORT sdte_refcount;		// # reasons why SDTE can't be deleted.
    USHORT sdte_handle;                 // internal ID maintained by FSD.
    PVOID sdte_dev;			// FWA, device driver header.
    USHORT sdte_fsd;			// seg adr, FSD driver.
    UCHAR sdte_curdir [SDTE_DIRLEN+1];	// zero-byte terminated.
    UCHAR sdte_unit;			// unit number within driver.
    UCHAR sdte_drive;			// drive handle (SDT handle).
    USHORT sdte_dpb;			// ofs FWA, fake DPB for funcs 1fh, 32h.
    USHORT sdte_prefix;                 // ofs FWA, ASCIIZ prefix in system pool.
    USHORT sdte_hintflags;		// flags used by FSD.
    USHORT sdte_hint1;			// long-term scratch for FSD.
    ULONG sdte_hint2;			// long-term scratch for FSD.
} SDTE, *PSDTE;

#endif // _SDTE
