/** $Revision:   1.1  $ **/
/**/
/*****************************************************************************
*
*   Title:        MVI Communications Module API Definitions
*
*   Abstract:     This file contains definitions and declarations
*                 needed for developing applications which use the
*                 MVI API.
*
*   Environment:  MVI Communications Module
*                 Borland/Microsoft C/C++ Compiler
*                 General Software Embedded DOS 6-XL
*
*                 Copyright (c) 1998-2000 Online Development, Inc.
*
*
*   Modified:
*    02/04/2003 -- Altered for the new direct I/O control backplane driver.
*
*
*
*
*
*
*
*****************************************************************************/

#ifndef _MVIBPAPI_H
#define _MVIBPAPI_H

/***********************************
**      TYPE DEFINITIONS
************************************/
typedef unsigned char   BYTE;       // 8-bit unsigned value
typedef unsigned short  WORD;       // 16-bit unsigned value
typedef unsigned long   DWORD;      // 32-bit unsigned value
typedef unsigned short  MVIHANDLE;  // API handle


/************************************
**    API FUNCTION RETURN CODES
*************************************/
#define MVI_SUCCESS             0       // Function returned successfully
#define MVI_ERR_BADPARAM        1       // A parameter is invalid
#define MVI_ERR_REOPEN          2       // Device is already open
#define MVI_ERR_NODEVICE        3       // Device is not present
#define MVI_ERR_NOACCESS        4       // Invalid access
#define MVI_ERR_TIMEOUT         5       // The function has timed out
#define MVI_ERR_MSGTOOBIG       6       // The message is too large
#define MVI_ERR_BADCONFIG       7       // The IO is not configured properly
#define MVI_ERR_MEMALLOC        8       // Unable to allocate memory
#define MVI_ERR_NOTSUPPORTED    9       // Function is not supported on this platform
#define MVI_NO_MSG				10		// No message pending or present
#define MVI_MSG_PENDING			11		// Message is pending

// 1746MVI Specific Error Codes
#define MVI46_ERR_INVALIDCLASS  400     /* Not supported with current class */
#define MVI46_ERR_SERVFAIL      401     /* SLC Service request failed       */
#define MVI46_ERR_UPDATEDIS     402     /* Update interrupt not enabled     */
#define MVI46_ERR_PROGMODE      403     /* MVI not in RUN mode              */
#define MVI46_ERR_UPDATEBUSY    404     /* There is already an update in progress */
#define MVI46_ERR_SLOTDIS       405     /* The slot has been disabled by the SLC */

/************************************
**    MESSAGING CONTROL CODES
*************************************/
#define MVI_MSG_POLL			0x0000	/* Forces message status retrieval when used */
										/* in length parameter field */
/************************************
**    USER LED DEFINITIONS
**
**    These values are passed to the
**    MVIbp_SetUserLED function.
*************************************/
#define MVI_LED_USER1       1           // Selects User LED1
#define MVI_LED_USER2       2           // Selects User LED2
#define MVI_LED_USER3       3           // Selects User LED3 (not supported on all platforms)
#define MVI_LED_STATE_OFF   0           // LED is OFF
#define MVI_LED_STATE_ON    1           // LED is ON


/************************************
**    MODULE STATUS DEFINITIONS
**
**    These values are passed to the
**    MVIbp_SetModuleStatus function.
*************************************/
#define MVI_MODULE_STATUS_OK        0   // Module is OK
#define MVI_MODULE_STATUS_FAULTED   1   // Module is faulted
#define MVI_MODULE_STATUS_FLASHING  2   // Flashing Red/Green


/**********************************************
**    PROCESSOR STATUS DEFINITIONS
**
**    The following bit masks define
**    bits in the status word returned by the
**    MVIbp_GetProcessorStatus function.
**
**    Note: The MVIbp_GetProcessorStatus function
**    is not supported on the 1794 platform.
***********************************************/
#define MVI_PROCESSOR_STATUS_RUN    1   // Processor is in Run Mode
#define MVI_DATA_CONNECTION_OPEN    2   // Data connection is open (1756 only)
#define MVI_STATUS_CONNECTION_OPEN  4   // Status connection is open (1756 only)


/**********************************************
**    MODULE FILE TYPES
**
**    These values are passed to the
**    MVIbp_ReadModuleFile and MVIbp_WriteModuleFile
**    functions.
**
**    Note: The MVIbp_ReadModuleFile and
**    MVIbp_WriteModuleFile functions are
**    supported on the 1746 platform only.
***********************************************/
#define FILTYP_M0                   0x08    // M0 File
#define FILTYP_M1                   0x09    // M1 File



/**********************************************
**    I/O Control functions
**
**    These values are passed to the
**    functions.
**
**    Note: The MVIbp_ReadModuleFile and
**    MVIbp_WriteModuleFile functions are
**    supported on the 1746 platform only.
***********************************************/
//
// IOCTL functions:
//
#define MVIQ_IOCTL_GETBATTSTS     1
//
// ctlid = MVIQ_IOCTL_GETBATTSTS
// p = points to byte to receive battery status
//      1=Good, 0=Low
#define MVIQ_IOCTL_GETQIOCFG    100
//
// ctlid = MVIQ_IOCTL_GETQIOCFG
// p = points to MVIQ_IOCTL_IOCFG structure to receive CFG MSTR info
//
#define MVIQ_IOCTL_SETQIOCFG    101

#define MVIQ_IOCTL_READCPU      102

#define MVIQ_IOCTL_WRITECPU     103





/* ************************************ */
/* **    STRUCTURES                  ** */
/* ************************************ */

/* ensure structures are word-aligned */
#ifdef __BORLANDC__
#pragma option -a
#endif /* _BORLANDC */

#ifdef _MSC_VER
#pragma pack(2)
#endif /* _MSC_VER */

/************************************************************
* Structure Name: MVIBPVERSIONINFO
*
* Description:
*
*   Returned by MVIbp_GetVersionInfo().
*   API version numbers.
*
*************************************************************/
typedef struct tagMVIBPVERSIONINFO
{
    WORD        APISeries;                  // API series
    WORD        APIRevision;                // API revision
    WORD        BPDDSeries;                 // Backplane driver series
    WORD        BPDDRevision;               // Backplane driver revision
    BYTE        Reserved[8];                // Reserved
} MVIBPVERSIONINFO;

/************************************************************
* Structure Name: MVIBPIOCONFIG
*
* Description:
*
*   Returned by MVIbp_GetIOConfig().
*
*************************************************************/
typedef struct tagMVIBPIOCONFIG
{
    WORD    TotalInputSize;     // Size of entire input image in words
    WORD    TotalOutputSize;    // Size of entire output image in words
    WORD    DirectInputSize;    // Number of input words available for direct access
    WORD    DirectOutputSize;   // Number of output words available for direct access
    WORD    MsgRcvBufSize;      // Max size in words for received messages
    WORD    MsgSndBufSize;      // Max size in words for transmitted messages
} MVIBPIOCONFIG;

/************************************************************
* Structure Name: MVIBPMODULEINFO
*
* Description:
*
*   Returned by MVIbp_GetModuleInfo().
*
*************************************************************/
typedef struct tagMVIBPMODULEINFO
{
    WORD    VendorID;           // Reserved
    WORD    DeviceType;         // Reserved
    WORD    ProductCode;        // Device model code
    BYTE    MajorRevision;      // Module major revision
    BYTE    MinorRevision;      // Module minor revision
    DWORD   SerialNo;           // Serial number
    BYTE    Name[32];           // Device name (string)
    BYTE    Month;              // Date of manufacture - month
    BYTE    Day;                // Date of manufacture - day
    WORD    Year;               // Date of manufacture - year
} MVIBPMODULEINFO;



// 1. MVIQ_IOCTL_GETQIOCFG now returns sizes of 0x, 1x, 3x and 4x data
//    tables. The structure of data returned is now defined as:

typedef struct
{
    WORD InputIndex;
    WORD OutputIndex;
    WORD InputWords;
    WORD OutputWords;
    WORD Cpu_0X_discretes;  // number of 0x discretes (16 per word)(number of bits)
    WORD Cpu_1X_discretes;  // number of 1x discretes (16 per word)(number of bits)
    WORD Cpu_3X_words;
    WORD Cpu_4X_words;
} MVIQ_IOCTL_IOCFG;

//2. New Function RandomCPURead:
//
// This function is implemented as an IOCTL with a new structure:
// #define MVIQ_IOCTL_READCPU      102

typedef struct
{
    WORD DataType;   // 0, 1, 3, or 4
    WORD *pBuffer;   // pointer to data
    WORD offset;     // word offset into data table
    WORD length;     // number of words to xfer
} MVIQ_IOCTL_CPUXFERREQ;


/* return packing alignment to default */
#ifdef __BORLANDC__
#pragma option -a.
#endif /* _BORLANDC */

#ifdef _MSC_VER
#pragma pack()
#endif /* _MSC_VER */


/*************************************
**      FUNCTION PROTOTYPES         **
*************************************/

/* Define a convenient macro for library function declarations */

#ifdef __cplusplus
#define MVIAPIENTRY extern "C" int pascal
#define MVIAPIENTRYW extern "C" WORD pascal
#else
#define MVIAPIENTRY int pascal
#define MVIAPIENTRYW WORD pascal
#endif


MVIAPIENTRY MVIbp_Open(MVIHANDLE *);
MVIAPIENTRY MVIbp_Close(MVIHANDLE);
MVIAPIENTRY MVIbp_GetIOConfig(MVIHANDLE, MVIBPIOCONFIG *);
MVIAPIENTRY MVIbp_SetIOConfig(MVIHANDLE, MVIBPIOCONFIG *);
MVIAPIENTRY MVIbp_WaitForInputScan(MVIHANDLE, WORD);
MVIAPIENTRY MVIbp_WaitForOutputScan(MVIHANDLE, WORD);
MVIAPIENTRY MVIbp_ReadOutputImage(MVIHANDLE, WORD *, WORD, WORD);
MVIAPIENTRY MVIbp_WriteInputImage(MVIHANDLE, WORD *, WORD, WORD);
MVIAPIENTRY MVIbp_ReceiveMessage(MVIHANDLE, WORD *, WORD *, WORD, WORD);
MVIAPIENTRY MVIbp_SendMessage(MVIHANDLE, WORD *, WORD, WORD, WORD);
MVIAPIENTRY MVIbp_GetModuleInfo(MVIHANDLE, MVIBPMODULEINFO *);
MVIAPIENTRY MVIbp_GetVersionInfo(MVIHANDLE, MVIBPVERSIONINFO *);
MVIAPIENTRY MVIbp_ErrorString(int, char *);
MVIAPIENTRY MVIbp_SetUserLED(MVIHANDLE, int, int);
MVIAPIENTRY MVIbp_SetModuleStatus(MVIHANDLE, int);
MVIAPIENTRY MVIbp_GetSetupMode(MVIHANDLE, int *);
MVIAPIENTRY MVIbp_GetConsoleMode(MVIHANDLE, int *, int *);
MVIAPIENTRY MVIbp_SetConsoleMode(MVIHANDLE, int, int);
MVIAPIENTRY MVIbp_GetProcessorStatus(MVIHANDLE, WORD *);
MVIAPIENTRY MVIbp_Sleep(MVIHANDLE, WORD);

/* 1746 Platform Specific Functions */
MVIAPIENTRY MVIbp_SetModuleInterrupt(MVIHANDLE);
MVIAPIENTRY MVIbp_ReadModuleFile(MVIHANDLE, int, WORD *, WORD, WORD);
MVIAPIENTRY MVIbp_WriteModuleFile(MVIHANDLE, int, WORD *, WORD, WORD);


/******************************************
** Undocumented IOCTL Backplane function
*******************************************/
MVIAPIENTRY MVIbp_IOCTL(MVIHANDLE h, int ctlid, void *p);




#endif  /* _MVIBPAPI_H */
