;***	FSCTL.INC -- Embedded DOS File System Control Packet Structures.
;
;1.	Functional Description.
;	This include file contains the structure definitions for the
;	file system control packets used by system components of Embedded DOS.
;
;	The main user of these definitions is DOSNET.ASM, which passes
;	these FSCTL buffers to DFSFSD.ASM through IoFileControl.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

;	The following command codes are used by DFSFSD to determine
;	which operation to perform.

DFSCTL_CMD_ATTACH	=	0
DFSCTL_CMD_DETACH	=	1
DFSCTL_CMD_SHARE	=	2
DFSCTL_CMD_UNSHARE	=	3
DFSCTL_CMD_LIMIT	=	(DFSCTL_CMD_UNSHARE) ; last possible cmd code.

;***	DFSCTL - Generic DFS File Control Packet.
;
;	This structure defines the layout of a packet, the address of which
;	is passed in the fsrp_buffer of IoFileControl FSRPs destined to DFSFSD.

DFSCTL		struc
dfsctl_cmd	dw	?		; command code, documented above.
DFSCTL		ends

;***	DFSCTL_ATTACH - DFS File Control Packet For Attaching To A Network.
;
;	This structure defines the layout of a packet, the address of which
;	is passed in the fsrp_buffer of ATTACH FSRPs destined to DFSFSD.
;	The ATTACH function instructs the DFS to provide services over the
;	named MAC driver by binding.

DFSCTL_ATTACH		struc
dfsctl_attach_cmd	dw	?	; command code, documented above.
dfsctl_attach_macname	dd	?	; FWA, ASCIIZ name of MAC driver to attach to.
DFSCTL_ATTACH		ends

;***	DFSCTL_DETACH - DFS File Control Packet For Detaching From A Network.
;
;	This structure defines the layout of a packet, the address of which
;	is passed in the fsrp_buffer of DETACH FSRPs destined to DFSFSD.
;	The DETACH function instructs the DFS to terminate operation over
;	the named MAC driver by unbinding.

DFSCTL_DETACH		struc
dfsctl_detach_cmd	dw	?	; command code, documented above.
dfsctl_detach_macname	dd	?	; FWA, ASCIIZ name of MAC driver to detach from.
DFSCTL_DETACH		ends

;***	DFSCTL_SHARE - DFS File Control Packet For Sharing An Object.
;
;	This structure defines the layout of a packet, the address of which
;	is passed in the fsrp_buffer of SHARE FSRPs destined to DFSFSD.
;	The SHARE function instructs the DFS to offer a locally-addressable
;	object in the DFS naming hierarchy over all of its addressable networks.

DFSCTL_SHARE		struc
dfsctl_share_cmd	dw	?	; command code, documented above.
dfsctl_share_local	dd	?	; FWA, ASCIIZ name of local object.
dfsctl_share_dfs	dd	?	; FWA, ASCIIZ name of object in DFS.
DFSCTL_SHARE		ends

;***	DFSCTL_UNSHARE - DFS File Control Packet For Terminating An Object Offering.
;
;	This structure defines the layout of a packet, the address of which
;	is passed in the fsrp_buffer of UNSHARE FSRPs destined to DFSFSD.
;	The UNSHARE function instructs the DFS to terminate an offer to
;	share a locally-addressable object in the DFS naming hierarchy.

DFSCTL_UNSHARE		struc
dfsctl_unshare_cmd	dw	?	; command code, documented above.
dfsctl_unshare_dfs	dd	?	; FWA, ASCIIZ name of object in DFS.
DFSCTL_UNSHARE		ends
