//***	FSIB.H -- File System Information Buffer for C Implementations.
//
//1.	Functional Description.
//	This include file contains structure definitions for use by
//	file system drivers (FSDs) written in C.
//
//2.	Modification History.
//	G. A. Blanchard 93/03/14.	#1.101, original.
//	S. E. Jones	93/09/26.	#2.000, release.
//	S. E. Jones	95/01/24.	#2.2, release.
//
//3.	NOTICE: Copyright (C) 1993-1995 General Software, Inc.

#ifndef _FSIB
#define _FSIB

//
// This structure defines the layout of a File System Information Buffer.
//

typedef struct _FSIB {
    ULONG fsib_tau;			// total allocation units (clusters).
    ULONG fsib_fau;			// free allocation units (unallocated).
    USHORT fsib_bpau;			// blocks per allocation unit.
    USHORT fsib_bs;			// block size, in bytes.
    PVOID fsib_bpb;			// ptr to BPB for MS-DOS device drivers.
} FSIB, *PFSIB;

#endif // _FSIB
