;***	SFTE.INC -- DOS System File Table Entry.
;
;1.	Functional Description.
;	This structure defines the layout of a DOS System File Table Entry
;	(SFTE) as expected by Microsoft Windows when it scans the anchor
;	block with DosGetAnchor.  Although the exact specifications for
;	this structure are not published by Microsoft, we were able to
;	determine what most of these fields were through experimentation
;	and through the notes provided by curious types on BBS's, etc.
;	Special thanks to "pete@octopus" for his stuff we saw on the net.
;	Naturally, "pete" can't be held responsible for this information.
;	This structure is also well-documented in the Addison-Wesley book,
;	"Undocumented DOS", by Andrew Schulman, Ray Michels, Jim Kyle,
;	Tim Paterson, David Maxey, and Ralf Brown.
;
;2.	Modification History.
;	S. E. Jones	91/03/09.	Added to initialization.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

SFTE		struc
sfte_usecount	dw	?	; number of reasons why SFTE can't be deleted.
sfte_mode	dw	?	; open mode.
sfte_attrib	db	?	; open file's attribute byte.
sfte_devinfo	dw	?	; device information word, if device.
sfte_devptr	dd	?	; character device header, else DPB if file.
sfte_start	dw	?	; starting cluster number if file.
sfte_time	dw	?	; file's timestamp (see INT 21h function 57h).
sfte_date	dw	?	; file's datestamp (see INT 21h function 57h).
sfte_size	dd	?	; size of file in bytes.
sfte_fileptr	dd	?	; current file pointer (byte offset).
sfte_logclust	dw	?	; logical cluster # of last-accessed cluster.
sfte_phyclust	dw	?	; physical cluster # of last-accessed cluster.
sfte_dirsect	dw	?	; directory entry's sector number.
sfte_dirent	db	?	; index into sector of directory entry.
sfte_fname	db	11 dup (?) ; filename in 8.3 (but blank-padded) form.
sfte_sharelink	dd	?	; used by SHARE.EXE.
sfte_machine	dw	?	; used by SHARE.EXE.
sfte_owner	dw	?	; owning PSP for this file.
sfte_share	dw	?	; used by SHARE.EXE.
SFTE		ends
