/** $Revision:   1.1  $ **/
/**/
/*****************************************************************************
*
*   Title:        1756-MVI Serial Communications Module CIP API Definitions
*
*   Abstract:     This file contains definitions and declarations
*                 needed for developing applications which use the
*                 1756-MVI CIP API.
*
*   Environment:  1756-MVI Serial Communications Module
*                 Borland/Microsoft C/C++ Compiler
*                 General Software Embedded DOS 6-XL
*
*                 Copyright (c) 1999-2001 Online Development, Inc.
*
*****************************************************************************/

#ifndef _MVICIPAPI_H
#define _MVICIPAPI_H

/***********************************
**      TYPE DEFINITIONS
************************************/
typedef unsigned char   BYTE;       // 8-bit unsigned value
typedef unsigned short  WORD;       // 16-bit unsigned value
typedef unsigned long   DWORD;      // 32-bit unsigned value
typedef unsigned short  MVIHANDLE;  // API handle


/************************************
**    API FUNCTION RETURN CODES
*************************************/
#define MVI_SUCCESS                 0   // Function returned successfully
#define MVI_ERR_BADPARAM            1   // A parameter is invalid
#define MVI_ERR_REOPEN              2   // Device is already open
#define MVI_ERR_NODEVICE            3   // Device is not present
#define MVI_ERR_NOACCESS            4   // Invalid access
#define MVI_ERR_TIMEOUT             5   // The function has timed out
#define MVI_ERR_MSGTOOBIG           6   // The message is too large
#define MVI_ERR_BADCONFIG           7   // The IO is not configured properly
#define MVI_ERR_MEMALLOC            8   // Unable to allocate memory
#define MVI_ERR_NOTSUPPORTED        9   // Function is not supported on this platform
#define MVI_ERR_ALREADY_REGISTERED 10   // Object is already registered
#define MVI_ERR_INVALID_OBJHANDLE  11   // Object handle is not valid
#define MVI_ERR_NODATA             12   // No data has been received on this connection yet
#define MVI_ERR_INVALID            13   // Invalid function for current state or configuration
#define MVI_ERR_BUSY               14   // Device is busy - retry function
#define MVI_ERR_REINIT             15   // Failed because already initialized
#define MVI_ERR_NOINIT             16   // Failed because not initialized



/************************************
**    USER LED DEFINITIONS
**
**    These values are passed to the
**    MVIcip_SetUserLED function.
*************************************/
#define MVI_LED_USER1       1           // Selects User LED1
#define MVI_LED_USER2       2           // Selects User LED2
#define MVI_LED_STATE_OFF   0           // LED is OFF
#define MVI_LED_STATE_ON    1           // LED is ON


/************************************
**    MODULE STATUS DEFINITIONS
**
**    These values are passed to the
**    MVIcip_SetModuleStatus function.
*************************************/
#define MVI_MODULE_STATUS_OK        0   // Module is OK
#define MVI_MODULE_STATUS_FAULTED   1   // Module is faulted
#define MVI_MODULE_STATUS_FLASHING  2   // Flash RED/GREEN

/************************************
**    API CALLBACK REASON
**
**    These values are passed to the
**    connect_proc callback function.
*************************************/
#define MVI_CIP_CONN_OPEN           0   // Request to an open connection
#define MVI_CIP_CONN_CLOSE          1   // Request to close a connection
#define MVI_CIP_CONN_OPEN_COMPLETE  2   // Request to open a connection has completed
#define MVI_CIP_CONN_NULLOPEN       3   // NULL forward open request received

/************************************
**    API CALLBACK SERVICE CODES
**
**    These values are passed to the
**    service_proc callback function.
*************************************/
#define MVI_CIP_SC_GET_ATTR_SINGLE  0x0E
#define MVI_CIP_SC_SET_ATTR_SINGLE  0x10
#define MVI_CIP_SC_GET_MEMBER       0x18
#define MVI_CIP_SC_SET_MEMBER       0x19

/************************************
**    API CALLBACK INSTANCE ATTRIBUTES
**
**    These values are passed to the
**    service_proc callback function.
*************************************/
#define MVI_CIP_IA_NUM_MEMBERS 0x01  // Number of members in dynamic asy
#define MVI_CIP_IA_MEMBER_LIST 0x02  // Member list for dynamic asy
#define MVI_CIP_IA_DATA        0x03  // Data (as bytes)
#define MVI_CIP_IA_SIZE        0x04  // Size of data (in bytes)

/************************************
**    API CALLBACK RETURN CODES
**
**    These values are returned by the
**    connect_proc and service_proc
**    callback functions.
*************************************/
#define MVI_CIP_FAILURE            0x01  // Connection Failure
#define MVI_CIP_NO_RESOURCE        0x02  // No more resources
#define MVI_CIP_BAD_INSTANCE       0x05  // Invalid Class Instance
#define MVI_CIP_PARTIAL_DATA       0x06  // Invalid data size
#define MVI_CIP_BAD_SERVICE        0x08  // Invalid service code
#define MVI_CIP_BAD_ATTR_DATA      0x09  // Invalid attribute data
#define MVI_CIP_ATTR_NOT_SETTABLE  0x0e  // Attribute cannot be set
#define MVI_CIP_DEVICE_BUSY        0x10  // The device application is not
                                         //  able to respond to the service request
#define MVI_CIP_BAD_ATTR           0x14  // Invalid attribute
#define MVI_CIP_DATA_TOO_BIG       0x15  // Data size is too large

/*****************************************
**    API CALLBACK EXTENDED ERROR CODES
**
**    These values may be returned by
**    the connect_proc callback function.
******************************************/
#define MVI_CIP_EX_CONNECTION_USED 0x100 // Connection already being used
#define MVI_CIP_EX_BAD_SIZE        0x109 // Invalid size
#define MVI_CIP_EX_NO_CNTRL_CONN   0x119 // No controlling connection is open
#define MVI_CIP_EX_BAD_RPI         0x111 // Unsupportable requested packet interval

/*****************************************
** API Device Id Status Read bit masks.
**    These are used to mask the status
**    word returned by the
**    MVIcip_GetDeviceIdStatus function.
******************************************/
#define MVI_ID_STATUS_DEVICE_STATUS_MASK 0x00F0
#define MVI_ID_STATUS_FLASHUPDATE        0x0010  // Flash update in progress
#define MVI_ID_STATUS_FLASHBAD           0x0040  // Flash is bad
#define MVI_ID_STATUS_FAULTED            0x0050  // Faulted
#define MVI_ID_STATUS_RUN                0x0060  // Run mode
#define MVI_ID_STATUS_PROGRAM            0x0070  // Program mode

#define MVI_ID_STATUS_FAULT_STATUS_MASK  0x0F00
#define MVI_ID_STATUS_RCV_MINOR_FAULT    0x0100  // Recoverable minor fault
#define MVI_ID_STATUS_URCV_MINOR_FAULT   0x0200  // Unrecoverable minor fault
#define MVI_ID_STATUS_RCV_MAJOR_FAULT    0x0400  // Recoverable major fault
#define MVI_ID_STATUS_URCV_MAJOR_FAULT   0x0800  // Unrecoverable major fault

// The key and controller mode bits are 555x specific
#define MVI_ID_STATUS_KEY_SWITCH_MASK    0x3000  // Key switch position mask
#define MVI_ID_STATUS_KEY_RUN            0x1000  // Keyswitch in run
#define MVI_ID_STATUS_KEY_PROGRAM        0x2000  // Keyswitch in program
#define MVI_ID_STATUS_KEY_REMOTE         0x3000  // Keyswitch in remote

#define MVI_ID_STATUS_CNTR_MODE_MASK     0xC000  // Controller mode bit mask
#define MVI_ID_STATUS_MODE_CHANGING      0x4000  // Controller is changing modes
#define MVI_ID_STATUS_DEBUG_MODE         0x8000  // Debug mode if controller is in Run mode

/* ************************************ */
/* **    STRUCTURES                  ** */
/* ************************************ */

/* ensure structures are byte-aligned */
#ifdef __BORLANDC__
#pragma option -a-
#endif /* _BORLANDC */

#ifdef _MSC_VER
#pragma pack(1)
#endif /* _MSC_VER */

/************************************************************
* Structure Name: MVICIPVERSIONINFO
*
* Description:
*
*   Returned by MVIcip_GetVersionInfo().
*   API version numbers.
*
*************************************************************/
typedef struct tagMVICIPVERSIONINFO
{
    WORD        APISeries;     // API series
    WORD        APIRevision;   // API revision
    WORD        BPDDSeries;    // Backplane driver series
    WORD        BPDDRevision;  // Backplane driver revision
} MVICIPVERSIONINFO;


/************************************************************
* Structure Name: MVICIPIDOBJ
*
* Description:
*
*   Returned by MVIcip_GetIdObject().
*
*************************************************************/
typedef struct tagMVICIPIDOBJ
{
    WORD    VendorID;           // Reserved
    WORD    DeviceType;         // Reserved
    WORD    ProductCode;        // Device model code
    BYTE    MajorRevision;      // Module major revision
    BYTE    MinorRevision;      // Module minor revision
    DWORD   SerialNo;           // Serial number
    BYTE    Name[32];           // Device name (string)
} MVICIPIDOBJ;


/************************************************************
* Structure Name: MVICIPCONNSTRUC
*
* Description:
*
*   A pointer to a structure of this type is passed to
*   the connect_proc callback routine.
*
*************************************************************/
typedef struct tagMVICIPCONNSTRUC
{
    MVIHANDLE   connHandle;     // unique value which identifies this connection
    DWORD       reg_param;      // value passed via MVIcip_RegisterAssemblyObj
    WORD        reason;         // specifies reason for callback
    WORD        instance;       // instance specified in open
    WORD        producerCP;     // producer connection point specified in open
    WORD        consumerCP;     // consumer connection point specified in open
    DWORD       *lOTApi;        // pointer to originator to target actual packet interval
    DWORD       *lTOApi;        // pointer to target to originator packet interval
    DWORD       lODeviceSn;     // Serial number of the originator
    WORD        iOVendorId;     // Vendor Id of the originator
    WORD        rxDataSize;     // size in bytes of receive data
    WORD        txDataSize;     // size in bytes of transmit data
    BYTE        *configData;    // pointer to configuration data sent in open
    WORD        configSize;     // size of configuration data sent in open
    WORD        *extendederr;   // Contains an extended error code if an error occurs
} MVICIPCONNSTRUC;


/************************************************************
* Structure Name: MVICIPSERVSTRUC
*
* Description:
*
*   A pointer to a structure of this type is passed to
*   the service_proc callback routine.
*
*************************************************************/
typedef struct tagMVICIPSERVSTRUC
{
    DWORD       reg_param;      // value passed via MVIcip_RegisterAssemblyObj
    WORD        instance;       // instance number of object being accessed
    BYTE        serviceCode;    // service being requested
    WORD        attribute;      // attribute being accessed
    BYTE        **msgBuf;       // pointer to pointer to message data
    WORD        offset;         // member offset
    WORD        *msgSize;       // pointer to size in bytes of message data
    WORD        *extendederr;   // Contains an extended error code if an error occurs
} MVICIPSERVSTRUC;


/************************************************************
* Structure Name: MVICIPRECVSTRUC
*
* Description:
*
*   A pointer to a structure of this type is passed to
*   the rxdata_proc callback routine.
*
*************************************************************/
typedef struct tagMVICIPRECVSTRUC
{
    DWORD       reg_param;      // value passed via MVIcip_RegisterAssemblyObj
    MVIHANDLE   connHandle;     // unique value which identifies this connection
    BYTE        *rxData;        // pointer to buffer of received data
    WORD        dataSize;       // size of received data in bytes
} MVICIPRECVSTRUC;


/* return packing alignment to default */
#ifdef __BORLANDC__
#pragma option -a.
#endif /* _BORLANDC */

#ifdef _MSC_VER
#pragma pack()
#endif /* _MSC_VER */


/*************************************
**      FUNCTION PROTOTYPES         **
*************************************/

/* Define a convenient macro for library function declarations */

#ifdef __cplusplus
#define MVIAPIENTRY extern "C" int pascal
#define MVIAPIENTRYW extern "C" WORD pascal
#else
#define MVIAPIENTRY int pascal
#define MVIAPIENTRYW WORD pascal
#endif

/* Define a convenient macro for callback function declarations */

#define MVICALLBACK int __loadds __cdecl

/* API Function Declarations */

MVIAPIENTRY MVIcip_Open(MVIHANDLE *);
MVIAPIENTRY MVIcip_Close(MVIHANDLE);
MVIAPIENTRY MVIcip_GetIdObject(MVIHANDLE, MVICIPIDOBJ *);
MVIAPIENTRY MVIcip_GetVersionInfo(MVIHANDLE, MVICIPVERSIONINFO *);
MVIAPIENTRY MVIcip_ErrorString(int, char *);
MVIAPIENTRY MVIcip_SetUserLED(MVIHANDLE, int, int);
MVIAPIENTRY MVIcip_SetDisplay(MVIHANDLE, char *);
MVIAPIENTRY MVIcip_SetModuleStatus(MVIHANDLE, int);
MVIAPIENTRY MVIcip_GetSetupMode(MVIHANDLE, int *);
MVIAPIENTRY MVIcip_GetConsoleMode(MVIHANDLE, int *, int *);
MVIAPIENTRY MVIcip_SetConsoleMode(MVIHANDLE, int, int);
MVIAPIENTRY MVIcip_RegisterAssemblyObj(MVIHANDLE, MVIHANDLE *, DWORD,
                int (__cdecl *)(MVIHANDLE, MVICIPCONNSTRUC *),
                int (__cdecl *)(MVIHANDLE, MVICIPSERVSTRUC *),
                int (__cdecl *)(MVIHANDLE, MVICIPRECVSTRUC *) );
MVIAPIENTRY MVIcip_UnregisterAssemblyObj(MVIHANDLE, MVIHANDLE);
MVIAPIENTRY MVIcip_WriteConnected(MVIHANDLE, MVIHANDLE, BYTE *, WORD, WORD);
MVIAPIENTRY MVIcip_ReadConnected(MVIHANDLE, MVIHANDLE, BYTE *, WORD, WORD);
MVIAPIENTRY MVIcip_RegisterFatalFaultRtn(MVIHANDLE, int (__cdecl *)());
MVIAPIENTRY MVIcip_RegisterResetReqRtn(MVIHANDLE, int (__cdecl *)());
MVIAPIENTRY MVIcip_RegisterFlashUpdateRtn(MVIHANDLE, int (__cdecl *)());
MVIAPIENTRY MVIcip_Sleep(MVIHANDLE, WORD);

#endif  /* _MVICIPAPI_H */

