/*---------------------------------------------------------------------------
**
**	MVICFG.C
**
**
**	(c) 1999-2000, Vital Computer Solutions, All Rights Reserved
**	Richard A. Reynolds
**
**	(c) 2000-2001, ProSoft Technologies, Inc., All Rights Reserved
**	Ken D. Hopwood
**
**	(c) 2002-2003, ProSoft Technologies, Inc., All Rights Reserved
**	Sukhum Amorntrakul (Joe)
**
**	Incorporates code from 01/2000 to 06/2000
**
**	MODIFIED :
**
**		12/14/2000 - 03/05/2001 -- Created example code from
**									existing works.
**		03/21/2001 -- added comments
**
**
**	Title:	This file contains the backplane example interface functions
**			for use with the ADM API.
**
**  Abstract:
**
**
**	This file contains the configuration validation logic.  The user
**	may modify the parameter checking to match the configuration needs
**	of the application.
**
**  Environment:	MVI
**                  MS-DOS
**                  Borland C/C++ Compiler (16-bit)
**
**
** ProSoft Technology, Inc. grants you a non-exclusive license to use, modify
** and re-distribute this program provided that this copyright notice and
** license appear on all copies of the software.
**
** Software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR
** IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE
** HEREBY EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE IS ASSUMED
** BY THE LICENSEE.
**
** PROSOFT TECHNOLOGY, INC. AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY
** DAMAGES SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
** DISTRIBUTING SOFTWARE.  IN NO EVENT WILL PROSOFT TECHNOLOGY, INC. OR ITS
** LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
** INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
** CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
** OR INABILITY TO USE SOFTWARE, EVEN IF PROSOFT TECHNOLOGY, INC. HAS BEEN
** ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
**
**---------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
**	Include files
**---------------------------------------------------------------------------
*/

#include "..\..\ADM-SAMPLE\inc\main_app.h"		/* primary application header file */
#include <string.h>
#include <stdio.h>


/*---------------------------------------------------------------------------
**	CONSTANT DEFINITIONS
**---------------------------------------------------------------------------
*/



/*---------------------------------------------------------------------------
**	Function prototypes
**---------------------------------------------------------------------------
*/

#if defined(MVI94) || defined(PTQ)
static void InitCfg(void);
int ReadCfg(void);
#endif

void ProcessCfg(void);



/*---------------------------------------------------------------------------
**	Variable definitions
**---------------------------------------------------------------------------
*/

extern ADM_BT_DATA	bt_data;
extern ADM_PORT ports[];
extern ADM_MODULE module;
extern ADMHANDLE adm_handle;				/* handle to ADM API */
extern ADM_INTERFACE interface;


/*---------------------------------------------------------------------------
** LOCAL MODULE DATA
**---------------------------------------------------------------------------
*/

static unsigned short MinDelay[] =
	{
		350,					/* #define     BAUD_110        0 */
		256,					/* #define     BAUD_150        1 */
		128,					/* #define     BAUD_300        2 */
		64, 					/* #define     BAUD_600        3 */
		32, 					/* #define     BAUD_1200       4 */
		16, 					/* #define     BAUD_2400       5 */
		8,  					/* #define     BAUD_4800       6 */
		4,  					/* #define     BAUD_9600       7 */
		2,  					/* #define     BAUD_19200      8 */
		2,  					/* #define     BAUD_28800      9 */
		1,  					/* #define     BAUD_38400      10 */
		0,  					/* #define     BAUD_57600      11 */
		0,  					/* #define     BAUD_115200     12 */
		0,0,0,0
	};


/*---------------------------------------------------------------------------
**	Functions
**---------------------------------------------------------------------------
*/


/*---------------------------------------------------------------------------
**	This function is valid for the MVI56 and MVI46 platforms.
**	This function is used to gather the configuration information
**	sent from the processor into the modules configuration.  The
**	buffer bt_data.rdbuff(MVI56) or bt_data.cbuff(MVI46) contains
**	the data received.
**---------------------------------------------------------------------------
*/


void ProcessCfg(void)
{
#if !defined( MVI94 ) && !defined( PTQ )
	int i;
#endif

#if defined(MVI56) || defined(MVI71)
	/* save transferred cfg data into database */
	ADM_DBSetRegs(adm_handle, BP_CFG_REGS, 6, (unsigned short *) bt_data.rdbuff+1);
	ADM_DBSetRegs(adm_handle, PORT1_SET_REGS, 9, (unsigned short *) bt_data.rdbuff+7);
	ADM_DBSetRegs(adm_handle, PORT2_SET_REGS, 9, (unsigned short *) bt_data.rdbuff+16);

	interface.ModCfgErr = 0;
	ports[0].CfgErr = 0;
	ports[1].CfgErr = 0;

	/* Module setup parameters */
	strcpy(module.name, PRODUCT_NAME);

	module.max_regs = ADM_MAX_DB_REGS;

	bt_data.rd_start = *(bt_data.rdbuff+1);
	if(bt_data.rd_start > (ADM_MAX_DB_REGS-1))
		interface.ModCfgErr |= 0x0001;
	if(bt_data.rd_start < 0)
		interface.ModCfgErr |= 0x0002;

	bt_data.rd_count = *(bt_data.rdbuff+2);
	if(bt_data.rd_count < 0)
		interface.ModCfgErr |= 0x0004;
	if((bt_data.rd_count+bt_data.rd_start) > ADM_MAX_DB_REGS)
		interface.ModCfgErr |= 0x0008;

	bt_data.wr_start = *(bt_data.rdbuff+3);
	if(bt_data.wr_start > (ADM_MAX_DB_REGS-1))
		interface.ModCfgErr |= 0x0010;
	if(bt_data.wr_start < 0)
		interface.ModCfgErr |= 0x0020;

	bt_data.wr_count = *(bt_data.rdbuff+4);
	if(bt_data.wr_count < 0)
		interface.ModCfgErr |= 0x0040;
	if((bt_data.wr_count+bt_data.wr_start) > ADM_MAX_DB_REGS)
		interface.ModCfgErr |= 0x0080;

	module.wr_start = bt_data.wr_start;
	module.wr_count = bt_data.wr_count;
	module.rd_start = bt_data.rd_start;
	module.rd_count = bt_data.rd_count;
	bt_data.bt_fail_cnt = *(bt_data.rdbuff+5);
	module.bt_fail_cnt  = bt_data.bt_fail_cnt;

#if defined(MVI56)
	bt_data.wr_blk_max  = bt_data.wr_count/200 + ((bt_data.wr_count%200) ? 1 : 0);

	bt_data.rd_blk_max   = bt_data.rd_count/200 + ((bt_data.rd_count%200) ? 1 : 0);
#elif defined(MVI71)
   if(!interface.cfg_file)  // use backplane transfer interface
   {
      // maximum number of block that is read by processor
      bt_data.wr_blk_max  = bt_data.wr_count/60 + ((bt_data.wr_count%60) ? 1 : 0);
      // maximum number of block that is write by processor
      bt_data.rd_blk_max   = bt_data.rd_count/60 + ((bt_data.rd_count%60) ? 1 : 0);
   }
   else  // use side-connect interface
   {
       // maximum number of block that is read by processor
      bt_data.wr_blk_max  = bt_data.wr_count/1000 + ((bt_data.wr_count%1000) ? 1 : 0);
       // maximum number of block that is write by processor
      bt_data.rd_blk_max   = bt_data.rd_count/1000 + ((bt_data.rd_count%1000) ? 1 : 0);
   }
#endif

	module.wr_blk_max   = bt_data.wr_blk_max;
	module.rd_blk_max   = bt_data.rd_blk_max;
	module.err_offset    = *(bt_data.rdbuff+6);
	if(module.err_offset < 0 || module.err_offset > ADM_MAX_DB_REGS-29)
	{
		module.err_offset = -1;
		module.err_freq   =  0;
	}
	else
		module.err_freq   =  500;

	/* Communications port set up parameters */
	for(i = 0; i < MAX_APP_PORTS; i++)
	{
		ports[i].enabled = (*(bt_data.rdbuff+7+i*9)) ? 'Y' : 'N';
		if(ports[i].enabled != 'Y' && ports[i].enabled != 'N')
      {
         ports[i].enabled = 'N';
      }

		ports[i].baud          = *(bt_data.rdbuff+8+i*9);
		switch(ports[i].baud)
		{
			case 110:
				ports[i].baud = BAUD_110;
				break;

			case 150:
				ports[i].baud = BAUD_150;
				break;

			case 300:
				ports[i].baud = BAUD_300;
				break;

			case 600:
				ports[i].baud = BAUD_600;
				break;

			case 12:
			case 1200:
				ports[i].baud = BAUD_1200;
				break;

			case 24:
			case 2400:
				ports[i].baud = BAUD_2400;
				break;

			case 48:
			case 4800:
				ports[i].baud = BAUD_4800;
				break;

			case 96:
			case 9600:
				ports[i].baud = BAUD_9600;
				break;

			case 19:
			case 192:
			case 19200:
				ports[i].baud = BAUD_19200;
				break;

			case 28:
			case 288:
			case 28800:
				ports[i].baud = BAUD_28800;
				break;

			case 38:
			case 384:
			case 38400L:
				ports[i].baud = BAUD_38400;
				break;

			case 57:
			case 576:
				ports[i].baud = BAUD_57600;
				break;

			case 115:
			case 1152:
				ports[i].baud = BAUD_115200;
				break;

			default :
				ports[i].CfgErr |= 0x0020;
		}

		ports[i].parity        = *(bt_data.rdbuff+9+i*9);
		if(ports[i].parity < 0 || ports[i].parity > 4)
		{
			ports[i].parity = 0;
			ports[i].CfgErr |= 0x0040;
		}

		ports[i].databits      = *(bt_data.rdbuff+10+i*9);
		switch(ports[i].databits)
		{
			case 5:
			ports[i].databits = WORDLEN5;
				break;

			case 6:
				ports[i].databits = WORDLEN6;
				break;

			case 7:
				ports[i].databits = WORDLEN7;
				break;

			case 8:
				ports[i].databits = WORDLEN8;
				break;

			default :
				ports[i].CfgErr |= 0x0080;
		}

		ports[i].stopbits      = *(bt_data.rdbuff+11+i*9);
		switch(ports[i].stopbits)
		{
			case 1:
				ports[i].stopbits = STOPBITS1;
				break;

			case 2:
				ports[i].stopbits = STOPBITS2;
				break;

			default :
				ports[i].CfgErr |= 0x0100;
		}

		ports[i].RTS_On       = *(bt_data.rdbuff+12+i*9);

		ports[i].RTS_Off      = *(bt_data.rdbuff+13+i*9);

		ports[i].MinDelay     = *(bt_data.rdbuff+14+i*9);
		if(ports[i].MinDelay == 0)
			ports[i].MinDelay = MinDelay[ports[i].baud];

		ports[i].CTS    = (*(bt_data.rdbuff+15+i*9)) ? 'Y' : 'N';
		if(ports[i].CTS != 'Y' && ports[i].CTS != 'N')
			ports[i].CTS = 'N';

	}
#endif

#if defined(MVI46)

	/* save transferred cfg data into database */
	ADM_DBSetRegs(adm_handle, BP_CFG_REGS, 6, (unsigned short *) bt_data.cbuff+1);
	MVIbp_WriteModuleFile(interface.handle, FILTYP_M1, bt_data.cbuff+1, BP_CFG_REGS, 6);

	ADM_DBSetRegs(adm_handle, PORT1_SET_REGS, 9, (unsigned short *) bt_data.cbuff+7);
	MVIbp_WriteModuleFile(interface.handle, FILTYP_M1, bt_data.cbuff+7, PORT1_SET_REGS, 9);

	ADM_DBSetRegs(adm_handle, PORT2_SET_REGS, 9, (unsigned short *) bt_data.cbuff+16);
	MVIbp_WriteModuleFile(interface.handle, FILTYP_M1, bt_data.cbuff+16, PORT2_SET_REGS, 9);

	interface.ModCfgErr = 0;
	ports[0].CfgErr = 0;
	ports[1].CfgErr = 0;

	/* Module setup parameters */
	strcpy(module.name, PRODUCT_NAME);

	module.max_regs = ADM_MAX_DB_REGS;

	bt_data.bt_fail_cnt = *(bt_data.cbuff+5);

	module.err_offset    = *(bt_data.cbuff+6);
	if(module.err_offset < 0 || module.err_offset > ADM_MAX_DB_REGS-29)
	{
		module.err_offset = -1;
	}

	/* Communications port set up parameters */
	for(i = 0; i < MAX_APP_PORTS; i++)
	{
		ports[i].enabled = (*(bt_data.cbuff+7+i*9)) ? 'Y' : 'N';
		if(ports[i].enabled == 'Y')
		{

			ports[i].baud = *(bt_data.cbuff+8+i*9);
			switch(ports[i].baud)
			{
				case 110:
					ports[i].baud = BAUD_110;
					break;

				case 150:
					ports[i].baud = BAUD_150;
					break;

				case 300:
					ports[i].baud = BAUD_300;
					break;

				case 600:
					ports[i].baud = BAUD_600;
					break;

				case 12:
				case 1200:
					ports[i].baud = BAUD_1200;
					break;

				case 24:
				case 2400:
					ports[i].baud = BAUD_2400;
					break;

				case 48:
				case 4800:
					ports[i].baud = BAUD_4800;
					break;

				case 96:
				case 9600:
					ports[i].baud = BAUD_9600;
					break;

				case 19:
				case 192:
				case 19200:
					ports[i].baud = BAUD_19200;
					break;

				case 28:
				case 288:
				case 28800:
					ports[i].baud = BAUD_28800;
					break;

				case 38:
				case 384:
				case 38400L:
					ports[i].baud = BAUD_38400;
					break;

				case 57:
				case 576:
					ports[i].baud = BAUD_57600;
					break;

				case 115:
				case 1152:
					ports[i].baud = BAUD_115200;
					break;

				default :
					ports[i].CfgErr = 0x0008;
			}

			ports[i].parity        = *(bt_data.cbuff+9+i*9);
			if(ports[i].parity < 0 || ports[i].parity > 4)
			{
				ports[i].parity = 0;
				ports[i].CfgErr = 0x0010;
			}

			ports[i].databits      = *(bt_data.cbuff+10+i*9);
			switch(ports[i].databits)
			{
				case 5:
					ports[i].databits = WORDLEN5;
					break;

				case 6:
					ports[i].databits = WORDLEN6;
					break;

				case 7:
					ports[i].databits = WORDLEN7;
					break;

				case 8:
					ports[i].databits = WORDLEN8;
					break;

				default:
					ports[i].CfgErr = 0x0020;
			}

			ports[i].stopbits      = *(bt_data.cbuff+11+i*9);
			switch(ports[i].stopbits)
			{
				case 1:
					ports[i].stopbits = STOPBITS1;
					break;

				case 2:
					ports[i].stopbits = STOPBITS2;
					break;

				default:
					ports[i].CfgErr = 0x0040;
			}

			ports[i].RTS_On       = *(bt_data.cbuff+12+i*9);
			ports[i].RTS_Off      = *(bt_data.cbuff+13+i*9);
			ports[i].MinDelay     = *(bt_data.cbuff+14+i*9);
			if(ports[i].MinDelay == 0)
				ports[i].MinDelay = MinDelay[ports[i].baud];

			ports[i].CTS    = (*(bt_data.cbuff+15+i*9)) ? 'Y' : 'N';
			if(ports[i].CTS != 'Y' && ports[i].CTS != 'N')
				ports[i].CTS = 'N';
		}
	}

#endif
}


#if defined(MVI94) || defined(PTQ)

/*---------------------------------------------------------------------------
**	This function is valid for the MVI94 platform.
**	This function is used to initialize the configuration information
**	in the module.
**---------------------------------------------------------------------------
*/

static void InitCfg(void)
{
	strcpy(module.name, "NOT CONFIGURED");
	module.max_regs      = ADM_MAX_DB_REGS;
#if defined(PTQ)

	module.rd_start = 0;
	module.rd_count = 0;
	module.wr_start = 0;
	module.wr_count = 0;
	module.wr_blk_max = 0;
	module.rd_blk_max = 0;
	module.bt_fail_cnt = 0;

#elif defined(MVI94)
	module.err_offset    = -1;
	module.err_freq      = 0;
	module.wr_start      = 0;
	module.wr_count      = 12;
	module.wr_blk_max	 = module.wr_count/6 +
								((module.wr_count%6) ? 1 : 0);
	module.rd_start      = 0;
	module.rd_count      = 12;
	module.rd_blk_max    = module.rd_count/6 +
								((module.rd_count%6) ? 1 : 0);
	module.bt_fail_cnt   = 0;

	ports[0].enabled	= 'Y';
	ports[0].baud		= BAUD_115200;
	ports[0].parity		= PARITY_NONE;
	ports[0].databits	= WORDLEN8;
	ports[0].stopbits	= STOPBITS1;
	ports[0].MinDelay	= 0;
	ports[0].RTS_On		= 0;
	ports[0].RTS_Off	= 0;
	ports[0].CTS		= 'N';
#endif
}


static void Get_Port_Data_EEPROM(int i, char * str, char huge * mptr)
{
	char huge * tptr = mptr, c;
	int setPortReg = (i ? PORT2_SET_REGS : PORT1_SET_REGS);

	if((tptr = ADM_RAM_Find_Section(adm_handle, str)) != NULL)
	{
		c = ADM_RAM_GetChar(adm_handle, tptr, "Enable");

	    if(c == 'Y'){
			ports[i].enabled = 'Y';
			ADM_DBSetWord(adm_handle, setPortReg, 1);
		} else {
			ports[i].enabled = 'N';
			ADM_DBSetWord(adm_handle, setPortReg, 0);
		}
		setPortReg++;

		// check port parameters only if enabled
		if(ports[i].enabled == 'Y')
		{
			ports[i].baud = ADM_RAM_GetInt(adm_handle, tptr, "Baud Rate");
			ADM_DBSetWord(adm_handle, setPortReg, ports[i].baud);
			setPortReg++;
			switch(ports[i].baud)
			{
				case 110:
					ports[i].baud = BAUD_110;
					break;

				case 150:
					ports[i].baud = BAUD_150;
					break;

				case 300:
					ports[i].baud = BAUD_300;
					break;

				case 600:
					ports[i].baud = BAUD_600;
					break;

				case 12:
				case 1200:
				default :
					ports[i].baud = BAUD_1200;
					break;

				case 24:
				case 2400:
					ports[i].baud = BAUD_2400;
					break;

				case 48:
				case 4800:
					ports[i].baud = BAUD_4800;
					break;

				case 96:
				case 9600:
					ports[i].baud = BAUD_9600;
					break;

				case 19:
				case 192:
				case 19200:
					ports[i].baud = BAUD_19200;
					break;

				case 28:
				case 288:
				case 28800:
					ports[i].baud = BAUD_28800;
					break;

				case 38:
				case 384:
				case 38400L:
					ports[i].baud = BAUD_38400;
					break;

				case 57:
				case 576:
					ports[i].baud = BAUD_57600;
					break;

				case 115:
				case 1152:
					ports[i].baud = BAUD_115200;
					break;
			}

			c = ADM_RAM_GetChar(adm_handle, tptr, "Parity");
			switch(c)
			{
				case 'O':
				case 'o':
					ports[i].parity = PARITY_ODD;
					break;

				case 'E':
				case 'e':
					ports[i].parity = PARITY_EVEN;
					break;

				case 'M':
				case 'm':
					ports[i].parity = PARITY_MARK;
					break;

				case 'S':
				case 's':
					ports[i].parity = PARITY_SPACE;
					break;

				case 'N':
				case 'n':
				default :
					ports[i].parity = PARITY_NONE;
					break;
			}
			ADM_DBSetWord(adm_handle, setPortReg, ports[i].parity);
			setPortReg++;

			ports[i].databits      = ADM_RAM_GetInt(adm_handle, tptr, "Data Bits");
			switch(ports[i].databits)
			{
				case 5:
					ports[i].databits = WORDLEN5;
					break;

				case 6:
					ports[i].databits = WORDLEN6;
					break;

				case 7:
					ports[i].databits = WORDLEN7;
					break;

				case 8:
				default :
					ports[i].databits = WORDLEN8;
					break;
			}
			ADM_DBSetWord(adm_handle, setPortReg, (ports[i].databits+5));
			setPortReg++;

			ports[i].stopbits      = ADM_RAM_GetInt(adm_handle, tptr, "Stop Bits");
			switch(ports[i].stopbits)
			{
				case 1:
				default :
					ports[i].stopbits = STOPBITS1;
					break;

				case 2:
					ports[i].stopbits = STOPBITS2;
					break;
			}
			ADM_DBSetWord(adm_handle, setPortReg, (ports[i].stopbits+1));
			setPortReg++;

			ports[i].RTS_On       = ADM_RAM_GetInt(adm_handle, tptr, "RTS On");
			ADM_DBSetWord(adm_handle, setPortReg, ports[i].RTS_On);
			setPortReg++;

			ports[i].RTS_Off      = ADM_RAM_GetInt(adm_handle, tptr, "RTS Off");
			ADM_DBSetWord(adm_handle, setPortReg, ports[i].RTS_Off);
			setPortReg++;

			ports[i].MinDelay     = ADM_RAM_GetInt(adm_handle, tptr, "Minimum Command Delay");
			if(ports[i].MinDelay == 0)
				ports[i].MinDelay = MinDelay[ports[i].baud];
			ADM_DBSetWord(adm_handle, setPortReg, ports[i].MinDelay);
			setPortReg++;

			c = ADM_RAM_GetChar(adm_handle, tptr, "Use CTS Line");
			if(c == 'Y'){
				ports[i].CTS = 'Y';
				ADM_DBSetWord(adm_handle, setPortReg, 1);
			} else {
				ports[i].CTS = 'N';
				ADM_DBSetWord(adm_handle, setPortReg, 0);
			}
			setPortReg++;

/*
			ports[i].slave_id     = ADM_RAM_GetInt(adm_handle, tptr, "Slave ID");
			if(ports[i].slave_id <= 0 || ports[i].slave_id > 255)
				ports[i].slave_id = 1;
			MB_SetWord(setPortReg, ports[i].slave_id);
			setPortReg++;
*/
		}
	}
}


/*---------------------------------------------------------------------------
**	This function is valid for the MVI94 platform.
**	This function is used to gather the configuration information
**	sent from the flash into the modules configuration.
**---------------------------------------------------------------------------
*/

int ReadCfg(void)
{
	char   * cptr;

#if defined(PTQ)
	char huge * tptr;
	char section[40];
	int i;

	if(!ADM_EEPROM_ReadConfiguration(adm_handle))  //if no configuration data, return
	{
		printf("ERROR: No configuration return\n");
		return (1);
	}

	InitCfg();

	if((tptr = ADM_RAM_Find_Section(adm_handle, "[Module]")) != NULL)
	{
		cptr = (char*)ADM_RAM_GetString(adm_handle, tptr, "Module Name");
		if(cptr == NULL)
			strcpy(module.name, "No Module Name");
		else
		{
			if(strlen(cptr) > 80)
				*(cptr+80) = 0;
			strcpy(module.name, cptr);
			if(module.name[strlen(module.name)-1] < 32)
				module.name[strlen(module.name)-1] = 0;
		}

		module.rd_start = ADM_RAM_GetInt(adm_handle, tptr, "Read Register Start");
		if(module.rd_start > module.max_regs-1){
			module.rd_start = 0;
		}
		if(module.rd_start < 0){
			module.rd_start = 0;
		}
//printf("rd_start: %d\n", module.rd_start);

		module.rd_count = ADM_RAM_GetInt(adm_handle, tptr, "Read Register Count");
		if(module.rd_count > module.max_regs){
			module.rd_count = 0;
		}
		if(module.rd_count < 0){
			module.rd_count = 0;
		}
//printf("rd_count: %d\n", module.rd_count);

		module.wr_start = ADM_RAM_GetInt(adm_handle, tptr, "Write Register Start");
		if(module.wr_start > module.max_regs-1){
			module.wr_start = 0;
		}
		if(module.wr_start < 0){
			module.wr_start = 0;
		}
//printf("wr_start: %d\n", module.wr_start);

		module.wr_count = ADM_RAM_GetInt(adm_handle, tptr, "Write Register Count");
		if(module.wr_count > module.max_regs){
			module.wr_count = 0;
		}
		if(module.wr_count < 0){
			module.wr_count = 0;
		}
//printf("wr_count: %d\n", module.wr_count);

		bt_data.input_start_reg = ADM_RAM_GetInt(adm_handle, tptr, "3x Register Start");
		if(bt_data.input_start_reg > ADM_MAX_DB_REGS){
			bt_data.input_start_reg = 1;
		}
		if(bt_data.input_start_reg < 0){
			bt_data.input_start_reg = 1;
		}
//printf("input_start_reg: %d\n", bt_data.input_start_reg);

		bt_data.output_start_reg = ADM_RAM_GetInt(adm_handle, tptr, "4x Register Start");
		if(bt_data.output_start_reg > ADM_MAX_DB_REGS){
			bt_data.output_start_reg = 1;
		}
		if(bt_data.output_start_reg < 0){
			bt_data.output_start_reg = 1;
		}
//printf("output_start_reg: %d\n", bt_data.output_start_reg);

		bt_data.init_data = ADM_RAM_GetInt(adm_handle, tptr, "Initialize Output Data");
		if(bt_data.init_data > 1){
			bt_data.init_data = 0;
		}
		if(bt_data.init_data < 0){
			bt_data.init_data = 0;
		}
//printf("init_data: %d\n", bt_data.init_data);

		module.err_offset = ADM_RAM_GetInt(adm_handle, tptr, "Error/Status Block Pointer");
		if(module.err_offset < 0 || module.err_offset > module.max_regs-61)
		{
			module.err_offset = -1;
			module.err_freq   =  0;
		}
		else
		{
			module.err_freq   =  500;
		}

		module.err_freq = ADM_RAM_GetInt(adm_handle, tptr, "Error/Status Frequency");

		module.bt_fail_cnt =ADM_RAM_GetInt(adm_handle, tptr, "Backplane Fail Count");
		bt_data.bt_fail_cnt = module.bt_fail_cnt;

		module.rd_blk_max = module.rd_count/6 + ((module.rd_count%6)?1:0);
		if(module.rd_blk_max < 2)
			module.rd_blk_max = 2;
		bt_data.rd_blk_max = module.rd_blk_max;

		module.wr_blk_max = module.wr_count/6 + ((module.wr_count%6)?1:0);
		if(module.wr_blk_max < 2)
			module.wr_blk_max = 2;
		bt_data.wr_blk_max = module.wr_blk_max;

		bt_data.wr_start = module.wr_start;
		bt_data.wr_count = module.wr_count;
		bt_data.rd_start = module.rd_start;
		bt_data.rd_count = module.rd_count;

	}

	bt_data.rd_blk_last = -1;
	bt_data.rd_blk = 0;
	bt_data.wr_blk = 0;

	bt_data.bt_failed    = 0;
	bt_data.bt_fail_cntr = 0;

	for(i = 0; i < MAX_APP_PORTS; i++)
	{
		sprintf(section, "[Port %d]", i+1);
		Get_Port_Data_EEPROM(i, section, tptr);
	}

	ADM_Get_BP_Data_Exchange(adm_handle);

	return(0);

#elif defined(MVI94)

	interface.ModCfgErr = 0;
	ports[0].CfgErr = 0;

	InitCfg();

	/* Module section */

	cptr = ADM_FileGetString(adm_handle, "[Module]", "Module Name");
	if(cptr == NULL)
		strcpy(module.name, "No Module Name");
	else
	{
		if(strlen(cptr) > 80)
			*(cptr+80) = 0;
		strcpy(module.name, cptr);
		if(module.name[strlen(module.name)-1] < 32)
			module.name[strlen(module.name)-1] = 0;
	}

	module.max_regs = ADM_FileGetInt(adm_handle, "[Module]", "Maximum Register");
	if(module.max_regs <= 0 || module.max_regs > ADM_MAX_DB_REGS)
		module.max_regs = ADM_MAX_DB_REGS;

	module.err_offset = ADM_FileGetInt(adm_handle, "[Module]", "Error/Status Block Pointer");
	if(module.err_offset < 0 || module.err_offset > module.max_regs-61)
	{
		module.err_offset = -1;
		module.err_freq   =  0;
	}
	else
	{
		module.err_freq   =  500;
	}

	module.err_freq = ADM_FileGetInt(adm_handle, "[Module]", "Error/Status Frequency");

	module.wr_start = ADM_FileGetInt(adm_handle, "[Module]", "BT Read Start Register");
	if(module.wr_start > module.max_regs-1)
	{
		interface.ModCfgErr |= 0x0010;
		module.wr_start = 0;
	}
	if(module.wr_start < 0)
	{
		interface.ModCfgErr |= 0x0020;
		module.wr_start = 0;
	}

	module.wr_count = ADM_FileGetInt(adm_handle, "[Module]", "BT Read Register Count");
	if(module.wr_count > module.max_regs)
	{
		interface.ModCfgErr |= 0x0080;
		module.wr_count = 12;
	}
	if(module.wr_count < 12)
	{
		interface.ModCfgErr |= 0x0040;
		module.wr_count = 12;
	}

	module.rd_start = ADM_FileGetInt(adm_handle, "[Module]", "BT Write Start Register");
	if(module.rd_start > module.max_regs-1)
	{
		interface.ModCfgErr |= 0x0001;
		module.rd_start = 0;
	}
	if(module.rd_start < 0)
	{
		interface.ModCfgErr |= 0x0002;
		module.rd_start = 0;
	}

	module.rd_count = ADM_FileGetInt(adm_handle, "[Module]", "BT Write Register Count");
	if(module.rd_count > module.max_regs)
	{
		interface.ModCfgErr |= 0x0008;
		module.rd_count = 12;
	}
	if(module.rd_count < 12)
	{
		interface.ModCfgErr |= 0x0004;
		module.rd_count = 12;
	}

	module.bt_fail_cnt = ADM_FileGetInt(adm_handle, "[Module]", "Backplane Fail Count");
	bt_data.bt_fail_cnt = module.bt_fail_cnt;

	module.rd_blk_max = module.rd_count/6 + ((module.rd_count%6)?1:0);
	if(module.rd_blk_max < 2)
		module.rd_blk_max = 2;
	bt_data.rd_blk_max = module.rd_blk_max;

	module.wr_blk_max = module.wr_count/6 + ((module.wr_count%6)?1:0);
	if(module.wr_blk_max < 2)
		module.wr_blk_max = 2;
	bt_data.wr_blk_max = module.wr_blk_max;

	bt_data.wr_start = module.wr_start;
	bt_data.wr_count = module.wr_count;
	bt_data.rd_start = module.rd_start;
	bt_data.rd_count = module.rd_count;

	/* Port section */
	ports[0].baud = ADM_FileGetInt(adm_handle, "[Port]", "Baud Rate");
	switch(ports[0].baud)
	{
		case 110:
			ports[0].baud = BAUD_110;
			break;

		case 150:
			ports[0].baud = BAUD_150;
			break;

		case 300:
			ports[0].baud = BAUD_300;
			break;

		case 600:
			ports[0].baud = BAUD_600;
			break;

		case 12:
		case 1200:
			ports[0].baud = BAUD_1200;
			break;

		case 24:
		case 2400:
			ports[0].baud = BAUD_2400;
			break;

		case 48:
		case 4800:
			ports[0].baud = BAUD_4800;
			break;

		case 96:
		case 9600:
			ports[0].baud = BAUD_9600;
			break;

		case 19:
		case 192:
		case 19200:
			ports[0].baud = BAUD_19200;
			break;

		case 28:
		case 288:
		case 28800:
			ports[0].baud = BAUD_28800;
			break;

		case 38:
		case 384:
		case 38400L:
			ports[0].baud = BAUD_38400;
			break;

		case 57:
		case 576:
			ports[0].baud = BAUD_57600;
			break;

		case 115:
		case 1152:
			ports[0].baud = BAUD_115200;
			break;

		default :
			ports[0].CfgErr |= 0x0020;
			ports[0].baud = BAUD_115200;
	}

	ports[0].parity = ADM_FileGetInt(adm_handle, "[Port]", "Parity");
	if(ports[0].parity < 0 || ports[0].parity > 4)
	{
		ports[0].CfgErr |= 0x0040;
		ports[0].parity = PARITY_NONE;
	}

	ports[0].databits = ADM_FileGetInt(adm_handle, "[Port]", "Data Bits");
	switch(ports[0].databits)
	{
		case 5:
			ports[0].databits = WORDLEN5;
			break;

		case 6:
			ports[0].databits = WORDLEN6;
			break;

		case 7:
			ports[0].databits = WORDLEN7;
			break;

		case 8:
			ports[0].databits = WORDLEN8;
			break;

		default:
			ports[0].CfgErr |= 0x0080;
			ports[0].databits = WORDLEN8;
	}

	ports[0].stopbits = ADM_FileGetInt(adm_handle, "[Port]", "Stop Bits");
	switch(ports[0].stopbits)
	{
		case 1:
			ports[0].stopbits = STOPBITS1;
			break;

		case 2:
			ports[0].stopbits = STOPBITS2;
			break;

		default :
			ports[0].CfgErr |= 0x0100;
			ports[0].stopbits = STOPBITS1;
	}

	ports[0].RTS_On  = ADM_FileGetInt(adm_handle, "[Port]", "RTS On");
	ports[0].RTS_Off = ADM_FileGetInt(adm_handle, "[Port]", "RTS Off");

	ports[0].CTS = ADM_FileGetChar(adm_handle, "[Port]", "Use CTS Line");
	if(ports[0].CTS != 'Y' && ports[0].CTS != 'N')
		ports[0].CTS = 'N';

	ports[0].MinDelay     = ADM_FileGetInt(adm_handle, "[Port]", "Minimum Response Delay");
	if(ports[0].MinDelay == 0)
		ports[0].MinDelay = MinDelay[ports[0].baud];

	ports[0].ComState = 0;        //State of serial communication
	ports[0].state    = 0;        //port state
	return 0;

#endif
}

#endif

