;***    DDT.INC -- Embedded DOS Drive Data Table.
;
;1.	Functional Description.
;	This structure defines the layout of an entry referenced by the
;       System Multiplex interrupt (2Fh) that supports DOS DRIVER.SYS
;       Get Drive Data Table List, Function 08h, Subfunction 03h. Each
;       element (in the list) describes the block device for a drive letter.
;       The first element (#0) corresponds to drive A:, element #1 corresponds
;	to drive B:, and so on.
;
;2.	Modification History.
;          M. Shepos    98/01/15.       Original.
;
;3.     NOTICE: Copyright (C) 1990-1998 General Software, Inc.


DDT             struc
ddt_NextDDT     dd      ?               ; Pointer to next DDT.
ddt_Int13Unit   db      ?               ; Physical unit number (for INT 13h).
ddt_LogicalNum  db      ?               ; Logical drive number.
ddt_Bpb         db      19 dup(?)       ; BIOS Parameter Block.
ddt_Flags       db      ?               ; Flags bit 6: 16-bit FAT.
ddt_DeviceOpens dw      ?               ; Number of DEVICE OPENs still open.
ddt_VolumeLabel db      'NO NAME    ',0 ; Volume label.
ddt_DeviceType  db      ?               ; Device type (INT 21h func 440Dh).
ddt_DriveFlag   dw      ?               ; Bit flags describing drive.
ddt_Cylinders   dw      ?               ; Number of cylinders.
ddt_HiCapBpb    db      19 dup(?)       ; Highest Capacity BIOS Parameter Block.
ddt_Reserved    db      12 dup(0)       ; Reserved.
ddt_LastAccess  dd      -1              ; Time of last access in clock ticks.
DDT             ends
