;***	USTRUC.INC -- Embedded DOS Structures For User Programs.
;
;1.	Functional Description.
;	This include file contains the structure definitions for the
;	public data structures exported by Embedded DOS to user programs.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	91/01/13.	Added new partitions to PTE.
;	S. E. Jones	92/01/17.	#1.095, fixed data constants in PSP.
;	S. E. Jones	92/02/20.	#1.096, updated devhdr bitflags.
;	S. E. Jones	92/07/26.	#1.099, added thread, object SPE types.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

	include ..\inc\iorp.inc
	include ..\inc\fsrp.inc

Longword	struc
lo		dw	?
hi		dw	?
Longword	ends

;***	DDE - Disk Directory Entry.
;
;	This structure defines the layout of a FAT file system directory
;	entry as it is formatted on the disk.  This layout was derived
;	from the information in Ray Duncan's "Advanced MS-DOS" book, published
;	by Microsoft Press, page 149.

DDE		struc
dde_filename	db	8 dup (?)	; first part of filename.
dde_ext         db	3 dup (?)	; second part of filename-- extension.
dde_flags	db	?		; attribute flags.
dde_reserved1	db	10 dup (?)	; reserved for future use (ours!).
dde_time	dw	?		; timestamp on file.
dde_date	dw	?		; datestamp on file.
dde_cluster	dw	?		; starting cluster number.
dde_size	dd	?		; file size in bytes.
DDE		ends

DDE_FLAGS_READONLY	=	01h	; file is read-only.
DDE_FLAGS_HIDDEN	=	02h	; file is excluded from normal searches.
DDE_FLAGS_SYSTEM	=	04h	; file is excluded from normal searches.
DDE_FLAGS_VOLUME_LABEL	=	08h	; this is a volume label entry.
DDE_FLAGS_DIRECTORY	=	10h	; this is a subdirectory.
DDE_FLAGS_ARCHIVE	=	20h	; file has been modified since last archive.
DDE_FLAGS_RESERVED1	=	40h	; reserved.
DDE_FLAGS_RESERVED2	=	80h	; reserved.

;***	ODE - Object Directory Entry.
;
;	This structure defines the layout of an object directory entry
;	returned by the FindFirst and FindNext DOS functions (4eh, 4fh).
;	See Ray Duncan's "Advanced MS-DOS" book, pg 363, for a description
;	of this area.  We added some fields to support general object types.

ODE_NAME_SIZE	=	64		; maximum size of ode_name string.

ODE		struc
ode_handle	dw	?		; system handle used in search.
ode_type	dw	?		; type of object returned.
ode_host	db	14 dup (?)	; returned ASCIIZ host name.
ode_fileid	dw	?		; for FAT, 1st cluster of file.
ode_access	db	?		; reserved for the future.
ode_attrib	db	?		; attribute of object.
ode_time	dw	?		; time stamp.
ode_date	dw	?		; date stamp.
ode_size	dd	?		; size of object in bytes.
ode_name	db	ODE_NAME_SIZE dup (?) ; DOS uses 13, but we extend it.
ODE		ends

ODE_TYPE_FILE		=	0	; this is a file/directory/volumelabel.
ODE_TYPE_MSGPORT	=	1	; this is a message port in the DFS.

ODE_ACCESS_READ         =	01h	; read access.
ODE_ACCESS_WRITE	=	02h	; write access.
ODE_ACCESS_EXEC         =	04h	; execute access.
ODE_ACCESS_DELETE	=	08h	; delete access.

ODE_FLAGS_READONLY	=	01h	; file is read-only.
ODE_FLAGS_HIDDEN	=	02h	; file is excluded from normal searches.
ODE_FLAGS_SYSTEM	=	04h	; file is excluded from normal searches.
ODE_FLAGS_VOLUME_LABEL	=	08h	; this is a volume label entry.
ODE_FLAGS_DIRECTORY	=	10h	; this is a subdirectory.
ODE_FLAGS_ARCHIVE	=	20h	; file has been modified since last archive.
ODE_FLAGS_RESERVED1	=	40h	; reserved.
ODE_FLAGS_RESERVED2	=	80h	; reserved.

;***	FCB - File Control Block.
;
;	This structure defines the layout of an FCB, which is used for the
;	DOS 1.0 compatibility file system calls.  This layout was derived
;	from the information in Ray Duncan's "Advanced MS-DOS" book, published
;	by Microsoft Press.

FCB		struc
fcb_driveid	db	?
fcb_filename	db	8 dup (?)	; first component of filename.
fcb_extension	db	3 dup (?)	; second component (after the dot).
fcb_cbn         dw	?		; current block number.
fcb_rs		dw	?		; current record size.
fcb_filesize	dd	?		; file size.
fcb_date	dw	?		; date that file was created/updated.
fcb_time	dw	?		; time that file was created/updated.

;	The following fields are reserved by Embedded DOS.

fcb_sfd         dw	?		; FWA, SFD covering this FCB.
		db	06h dup (?)	; reserved fields.

;	Continuation of the public components of an FCB.

fcb_crn         db	?		; current record number (yes, a byte).
fcb_rrn         dd	?		; relative record number (yes, a dd).
FCB		ends

;***	EFCB - Extended File Control Block.
;
;	This structure defines the layout of an Extended FCB, which is
;	used for extended DOS 1.0 compatibility file system calls.  Basically,
;	if in using an FCB, the DOS finds that fcb_driveid is 0ffh, then
;	it knows that the address is really pointing to an EFCB instead,
;	which contains an FCB plus some preamble stuff.

EFCB		struc
efcb_sig	db	?		; always 0ffh.
		db	5 dup (?)	; reserved.
efcb_attribute	db	?		; attribute byte.
efcb_fcb	db	(SIZE FCB) dup (?) ; the actual FCB, above.
EFCB		ends

;***	PSP - Program Segment Prefix.
;
;	This structure defines the layout of a PSP, which is built whenever
;	a .COM or .EXE program is loaded into memory.  In essence, this
;	structure is the process control block for the running program. It
;	contains a virtual handle translation table of 20 entries, which
;	contain indexes into the system-wide DOS Handle Table (DHT).  This
;	layout was derived from the information in Ray Duncan's "Advanced
;	MS-DOS" book, published by Microsoft Press.  Additional information
;	was derived from notes of various hackers who left valuable info
;	on public bulletin boards.
;
;	We use the SEGMENT AT 0 model instead of STRUC because we will
;	always have a PSP at a 0 offset, and so we just use ASSUME ES:PSP.

DOSFILELIMIT	=	20
DOSFILEUNUSED	=	0ffh		; byte stored in psp_filetbl if unused.

PSP		SEGMENT AT 0
psp_int20	db	2 dup (?)	; INT 20h instruction.
psp_loadsize	dw	?		; size of COM load.
		db	?		; reserved.
psp_farcall	db	5 dup (?)	; far call to DOS for CP/M compat.
psp_exit	dd	?		; DOS exit handler (int 22h).
psp_ctrlc	dd	?		; DOS ctrlc handler (int 23h).
psp_criterr	dd	?		; DOS critical error handler (int 24h).
psp_parentPSP	dw	?		; seg adr, parent PSP.
psp_filetbl	db	DOSFILELIMIT dup (?)
psp_environ	dw	?		; seg adr, environment area.
		db	10 dup (?)	; reserved.
psp_childPSP	dw	?		; seg adr, child PSP.

;	The following fields are reserved for Embedded DOS.  DosExec needs a
;	way to save the parent's SS:SP register pair during the loading
;	process before jumping to the image.  That's what these fields
;	are for.  By default, if the user doesn't modify the termination
;	address, our ISR20 code will load the parent's stack from these
;	fields and issue a RETN instruction.  This will seem to the user
;	like he just called function 4bh and it returned.  Caution, these
;	fields are stored in the PARENT's PSP, not the child's.

psp_savesp	dw	?		; saved SP (offset stored 1st).
psp_savess	dw	?		; saved SS.
psp_status	dw	?		; status code returned by 4ch.

;	The following fields are reserved by Embedded DOS to store the target
;	CS:IP and SS:SP for the image.

psp_targetip	dw	?		; new IP.
psp_targetcs	dw	?		; new CS.
psp_targetsp	dw	?		; new SP.
psp_targetss	dw	?		; new SS.
psp_targetax	dw	?		; new AX (count of drives, etc.)

;	Here's some extra space that the books reserve "for DOS".
;	We don't use them, but users shouldn't, either, since we
;	may need them to implement new functionality that users
;	ask for.

		db	18 dup (?)	; reserved.

;	Now the hard stuff that the user must fiddle with.

psp_fcb1	db	16 dup (?)	; WARNING: will overlay FCB2 if opened!
psp_fcb2	db	16 dup (?)	; second FCB (not entirely big enough).
		db	4 dup (?)	; filler.
psp_cmdlen	db	?		; length of command string.
psp_cmdstr	db	?		; variable length command string itself.

PSPLEN		=	($-psp_int20)
PSP		ENDS

;***	FSDHDR - Installable File System Header.
;
;	This structure defines the layout of the driver header in an FSD
;	driver.

FSD_VERSION	=	1

FSDHDR		struc
fsdhdr_fwdlink	dd	?		; far FWA, next FSD driver in system.
fsdhdr_name	db	8 dup (?)	; name of file system.
fsdhdr_reqept	dw	?		; ofs adr, FSD request entrypoint.
fsdhdr_version	dw	?		; FSD spec version we're coded to (1).
fsdhdr_fshelp	dd	?		; far FWA, system FS help handler.
FSDHDR		ends

;***	DEVHDR Installable Device Driver Header.
;
;	This structure defines the layout of the driver header in an
;	installable or system device driver.

DEVHDR		struc
devhdr_fwdlink	dd	?		; far FWA, next device driver in system.
devhdr_attr	dw	?		; device driver attributes.
devhdr_strat	dw	?		; code offset, strategy entrypoint.
devhdr_intr	dw	?		; code offset, interrupt entrypoint.
devhdr_name	db	8 dup (?)	; name of file system.
DEVHDR		ends

;	Device driver header attributes.

DEVATR_CHAR	=	8000h		; device is a character device.
DEVATR_IOCTL	=	4000h		; device can handle IOCTL read/write calls.
DEVATR_NONIBMBLK=	2000h		; block device, but non-IBM format.
DEVATR_OUTBUSY	=	2000h		; OVERLOADS!, output_until_busy supported.
DEVATR_EXTENDED =	1000h		; if set, this is an EDEVHDR.
DEVATR_OPNCLS	=	0800h		; open/close supported (3.x only).
DEVATR_V32	=	0040h		; generic IOCTL, get/set log drive supported.
DEVATR_INT29	=	0010h		; supports fast CON handler (int 29h).
DEVATR_CLOCK	=	0008h		; device is CLOCK.
DEVATR_NUL	=	0004h		; device is NUL.
DEVATR_BIGDISK	=	0002h		; block device uses 32-bit sector numbers.
DEVATR_CONOUT	=	0002h		; device is console output.
DEVATR_CONIN	=	0001h		; device is console input.

;	The following structure defines the layout of an extended device
;	header (Embedded DOS-specific) that is present only if the driver sets
;	the DEVATR_EXTENDED bit in its devhdr_attr field.  This allows us
;	to extend this header without breaking compatibility with MS-DOS.

EDEVHDR         struc
		db	(SIZE DEVHDR) dup (?) ; standard device header.
edevhdr_flags	dw	?		; extended capabilities.
edevhdr_resv	db	32 dup (?)	; reserved for future use, must be 0's.
EDEVHDR         ends

;	The following flags define the extended capabilities of the driver.
;	The MT and MP capabilities are related; if you set MP, you must set
;	MT, and that implies that all MP-safe drivers must be MT-safe as well.

EDEVHDR_FLAGS_SYNCH	=	0001h	; synchronous execution supported.
EDEVHDR_FLAGS_MT	=	0002h	; driver is MT-safe (multiple threads).
EDEVHDR_FLAGS_MP	=	0004h	; driver is MP-safe (multiple processors).

;***	BPB -- Bios Parameter Block Structure.
;
;	This include file contains the format of a BIOS Parameter Block as
;	found in a Partition Boot Record (PBR).

BPB		struc
bpb_BPS         dw	?		; bytes per sector.
bpb_SPC         db	?		; sectors per cluster.
bpb_RS		dw	?		; reserved sectors (in the boot record).
bpb_NFAT	db	?		; number of FATs.
bpb_MDE         dw	?		; max directory entries in root dir.
bpb_TS		dw	?		; total sectors.
bpb_MD		db	?		; media descriptor.
bpb_SPF         dw	?		; sectors per FAT.
bpb_SPT         dw	?		; sectors per track.
bpb_NH		dw	?		; number of heads.

;	The following two fields are extensions to the standard BPB.

bpb_HS		dd	?		; hidden sectors.
bpb_ETS         dd	?		; extended total sectors.

;	The following fields are private extensions for the disk driver.

bpb_spcyl	dw	?		; sectors per cylinder, calculated.
bpb_DriveNo	db	?		; BIOS drive number for this unit.
bpb_TimeStamp	dw	?		; last time we referenced this drive.
bpb_Valid	dw	?		; 0=re-read BPB, 1=BPB valid.

BPB		ends

;***	THREAD - Thread Control Block.
;
;	The following structure defines a thread object.  This object is
;	manipulated by the routines in THREAD.ASM.  All thread objects are
;	allocated from system pool, so they are all addressable in DOSDATA.
;	The THREAD object is not visible to kernel components that use the
;	THREAD object, but it is included here for the debugger.
;
;	Operations on threads are:
;	    AllocateThread - create a new thread and begin executing it.
;	    FreeThread - terminate the current thread.

THREAD		struc
thread_stackseg dw	?		; original allocated stack segment.

;	The following two fields must occur in exactly this order, as
;	the values of SS:SP are loaded with one LSS SP, <xxx> instruction.

thread_sp	dw	?		; stack pointer register.
thread_ss	dw	?		; stack segment register.

thread_flags	dw	?		; bitflags indicating thread's state.
thread_blockid	dw	?		; FWA, event/mutex if blocked.
THREAD		ends

THREAD_FLAGS_ACTIVE	=	0001h	; this object represents a real thread.
THREAD_FLAGS_CURRENT	=	0002h	; this is the current thread.
THREAD_FLAGS_BLOCKED	=	0004h	; this thread is blocked (mutex or event).
THREAD_FLAGS_386	=	0008h	; 80386/80486 state preserved.
THREAD_FLAGS_X87	=	0010h	; 80x87 state preserved.

;***	MUTEX - Mutex Object.
;
;	The following structure defines a mutex object.  This object is
;	manipulated by the routines in MUTEX.ASM.  All mutex objects are
;	allocated from system pool, so they are all addressable in DOSDATA.
;	The MUTEX object is not visible to kernel components that use the
;	MUTEX object, but it is included here for the debugger.
;
;	Operations on mutexes are:
;	    AllocateMutex - Create mutex and initialize it to the released state.
;	    FreeMutex - Destroy mutex, destroying blocked threads.
;	    AcquireMutex - Acquire mutex for exclusive access.
;	    ReleaseMutex - Release exclusive access on mutex to another thread.

MUTEX		struc
mutex_flags	dw	?		; current state of mutex.
MUTEX		ends

MUTEX_FLAGS_ACQUIRED =	0001h		; if set, mutex is acquired.

;***	EVENT - Event Object.
;
;	The following structure defines an event object.  This object is
;	manipulated by the routines in EVENT.ASM.  All event objects are
;	allocated from system pool, so they are all addressable in DOSDATA.
;	The EVENT object is not visible to kernel components that use the
;	EVENT object, but it is included here for the debugger.
;
;	Operations on events are:
;	    AllocateEvent - Create event and initialize it to the CLEARED state.
;	    FreeEvent - Destroy event and all threads blocked on it.
;	    SetEvent - Set event's state to SET.
;	    ClearEvent - Set event's state to CLEARED.
;	    PulseEvent - Pulse event's state momentarily and unblock one thread.

EVENT		struc
event_flags	dw	?		; current state of event.
EVENT		ends

EVENT_FLAGS_SET =  0001h		; if 1 event is set, else it is clear.

;***	PTE - Partition Table Entry.
;
;	This structure defines the format of a partition table entry as
;	formatted in the Master Boot Record (MBR) of each disk spindle
;	in the system.	It is used by routines in DSKDEV.ASM during
;	system initialization, but is also made visible here for debugging.

PTE		struc
pte_BootInd	db	?	; this is 80h for a bootable partition.
pte_FirstHead	db	?	; head number at start of partition.
pte_StartSectCyl dw	?	; low-order word sector number of PBR.
pte_SysInd	db	?	; system indicator.
pte_LastHead	db	?	; head number at end of partition.
pte_EndSectCyl	dw	?	; low-order word sector number of partition end.

pte_StartSect	dd	?	; starting relative sector number/this partition.
pte_EndSect	dd	?	; ending relative sector number/this partition.
PTE		ends

PTE_BOOTIND_BOOTABLE	=	80h	; value if partition is bootable.

PTE_SYSIND_UNKNOWN	=	00h	; unknown system type.
PTE_SYSIND_FAT12	=	01h	; primary partition, 12-bit FAT.
PTE_SYSIND_XENIX1	=	02h	; XENIX partition.
PTE_SYSIND_XENIX2	=	03h	; XENIX partition.
PTE_SYSIND_FAT16	=	04h	; primary partition, 16-bit FAT.
PTE_SYSIND_EXTDOS	=	05h	; extended DOS partition.
PTE_SYSIND_FSD		=	06h	; installable file system type.
PTE_SYSIND_NETWARE286	=	64h	; Novell NetWare 286.
PTE_SYSIND_NETWARE386	=	65h	; Novell NetWare 386.
PTE_SYSIND_MIRROR	=	87h	; OS/2 FT Mirror.
PTE_SYSIND_MIRROR_DISAB =	0c7h	; diabled OS/2 FT Mirror.
PTE_SYSIND_CONCURRENT	=	0dbh	; Digital Research Concurrent DOS partition.

;***	SPE - System Pool Entry.
;
;	This structure defines the layout of an entry in the system memory
;	pool when it is on the free list.  Entries cannot be extended or
;	shrunk; they are simply allocated and freed.  The fwdlink field
;	points to the next block in the list.  The usecnt field contains
;	the number of reasons why the block cannot be freed into the pool
;	again.	This allows multiple threads of execution to share the
;	same pool blocks and dynamically free them-- even at interrupt
;	time.  Of course, if spe_usecnt is equal to zero (0), then the
;	block is not in use.  Allocating a block intrinsically sets this
;	value to 1 so that other threads of execution cannot get at it.
;	The spe_length field contains the number of bytes in this block,
;	excluding the header (SIZE SPE-1).  The user of this block may
;	store its data following this header.

SPE		struc
spe_fwdlink	dw	?		; offset FWA, next free entry in pool.
spe_usecnt	dw	?		; reasons why we can't free this block.
spe_length	dw	?		; size of block in bytes.
spe_type	dw	?		; object type.
SPE		ends

SPE_TYPE_DATA		=	0	; default: just untyped data.
SPE_TYPE_EVENT		=	1	; event object.
SPE_TYPE_MUTEX		=	2	; mutex object.
SPE_TYPE_FFO		=	3	; FAT File object.
SPE_TYPE_TIMER		=	4	; timer object.
SPE_TYPE_IOBUF		=	5	; I/O system cooked buffer.
SPE_TYPE_USER_HANDLE_TABLE =	6	; PSP's extended handle table.
SPE_TYPE_SFD		=	7	; System FCB Descriptor.
SPE_TYPE_DPB		=	8	; Disk parameter block.
SPE_TYPE_SHTE		=	9	; System Handle Table Entry.
SPE_TYPE_SDTE		=	10	; System Drive Table Entry.
SPE_TYPE_SHT		=	11	; System Handle Table itself.
SPE_TYPE_SDT		=	12	; System Drive Table itself.
SPE_TYPE_PRINT_QUEUE	=	13	; Task-Time Spooler Print Queue.
SPE_TYPE_PREFIX         =	14	; prefix string for drive.
SPE_TYPE_MAC		=	15	; MAC (private) data structure.
SPE_TYPE_RPD		=	16	; Received Packet Descriptor.
SPE_TYPE_TPD		=	17	; Transmit Packet Descriptor.
SPE_TYPE_DFS		=	18	; DFS (private) data structure.
SPE_TYPE_NFO		=	19	; DFS Network File Object.
SPE_TYPE_LFO		=	20	; DFS Local File Object.
SPE_TYPE_NCB		=	21	; DFS Network Control Block.
SPE_TYPE_PCB		=	22	; DFS Prefix Control Block.
SPE_TYPE_FLR		=	23	; FAT Lock Record.
SPE_TYPE_FMT		=	24	; FAT Mapping Table.
SPE_TYPE_FCE		=	25	; FAT Cache Entry.
SPE_TYPE_THREAD         =	26	; Thread Object.
SPE_TYPE_OBJECT         =	27	; Named Object.
SPE_TYPE_LIMIT		=	28	; values at this or above are invalid.
