/*
// PROGRAM NAME:  HELLO32.C.
//
// FUNCTIONAL DESCRIPTION.
//	This program is a simple example of how the 32-bit context switching
//	is enabled in an Embedded DOS application program.
//
// MODIFICATION HISTORY.
//	S. E. Jones	93/09/18.	#1.106, original.
//
// INPUTS.
//	none.
//
// OUTPUTS.
//	none.
//
// COMMAND LINE ARGUMENTS.
//	none.
//
// NOTICE:  Copyright (C) 1993-1995 General Software, Inc.
*/

#include "..\inc\kernel.h"
#include "..\inc\system.h"
#include <conio.h>

VOID main ()
{
    UCHAR ch;
    USHORT ThreadFlags = THREAD_CAPABILITY_386;
    UCHAR *ThreadName;

    //
    // Retrieve our current thread name.
    //

    QueryThreadInformation (0, THREAD_INFOTYPE_NAME, &ThreadName);

    //
    // Tell the scheduler to run us as a 32-bit thread.
    //

    printf ("Enabling 32-bit context for thread '%s'.\n", ThreadName);
    SetThreadInformation (0, THREAD_INFOTYPE_FLAGS, &ThreadFlags);
    SetThreadInformation (0, THREAD_INFOTYPE_NAME, "Whopper-32");
    printf ("Press any key to terminate...");

    while (TRUE) {
	if (kbhit ()) {
	    break;
	}
    }
    ch = getch ();			     // wait for a keypress.
    printf ("\nReverting to 16-bit context.\n");

    //
    // Tell the scheduler to revert to a 16-bit context.
    //

    ThreadFlags &= ~THREAD_CAPABILITY_386;
    SetThreadInformation (0, THREAD_INFOTYPE_FLAGS, &ThreadFlags);

    //
    // Restore our old thread name.
    //

    SetThreadInformation (0, THREAD_INFOTYPE_NAME, ThreadName);

    printf ("Program terminated.\n");
    exit (0);
} // hello32.c
