	TITLE	IOHELPER - Simple I/O Helper Interface Test Program.

;***	IOHELPER -- Simple I/O Helper Interface Test Program.
;
;1.	Functional Description.
;	This program illustrates how to call Embedded DOS I/O Helper
;	services from an assembly-language program.  It has no output;
;	it simply opens a file called FOO, writes a message to the file,
;	and closes it again.
;
;2.	Modification History.
;	S. E. Jones	93/09/18.	#1.106, original.
;
;3.	NOTICE: Copyright (C) 1993 General Software.
;
;4.	Build Environment.
;	MASM 5.10, no special switches.

	include ..\inc\usegs.inc
	include ..\inc\udefines.inc
	include ..\inc\umacros.inc
	include ..\inc\ustruc.inc

;	Kernel definitions.

	include ..\inc\kernel.inc

;	I/O Helper definitions.

	include ..\inc\ioapi.inc

;	DOS call definitions to call the DOSEXIT INT 21h function.

	include ..\inc\dosapi.inc
	include ..\inc\doserr.inc

;	Define the stack.

_STACK	SEGMENT
	db	512 dup ('$')
TopStack =	$
_STACK	ENDS

UDATA	SEGMENT

IoHelper dd	?		; 16:16 I/O Helper address.

FileName db	'foo', 0	; name of file to create.

DataBuf db	'This is the data to be written to the file.', 13, 10
BUFSIZE =	($-DataBuf)

SuccessMsg db	'File created, written, and closed successfully.', 13, 10, '$'
NoCreateMsg db	'Unable to create file FOO.', 13, 10, '$'
NoWriteMsg db	'Unable to write to file FOO.', 13, 10, '$'
NoCloseMsg db	'Unable to close file FOO.', 13, 10, '$'

UDATA	ENDS

UCODE	SEGMENT

;***	Main - Main Entrypoint.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is the entrypoint of the test program.  We first
;	call the SYS_GET_IOHELP_ADDRESS kernel function to get the
;	system-wide I/O helper address, and store the function pointer
;	in a DWORD (IoHelper) for later.  Then we call I/O helper
;	functions indirectly through the DWORD pointer to open a file
;	called FOO, write a message to it, and close the file.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	93/09/18.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	all.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc Main, PUBLIC, FAR
	mov	ax, DGROUP
	mov	ds, ax
	ASSUME	DS:DGROUP		; (DS) = DGROUP.

;	Obtain the system I/O Helper function address.

	mov	dl, SYS_GET_IOHELP_ADDRESS
	int	SYSINT			; (DX:AX) = FWA, IoHelp dispatch.
	mov	IoHelper.hi, dx
	mov	IoHelper.lo, ax         ; save the address for our I/O calls.

;	Now open a file called FOO.

	mov	di, IOHELP_CREATE	; (DI) = function code.
	mov	dx, ds
	mov	ax, OFFSET DGROUP:FileName ; (DX:AX) = FWA, filename.
	mov	bx, 0			; (BX) = 0, meaning create a file.
	mov	cx, 0			; (CX) = file attributes.
	call	dword ptr [IoHelper]	; (BX) = resulting system handle.
	jc	Main_NoCreate		; if we couldn't create the file.

;	We have created FOO and have a handle in (BX).	Now write to it.

	mov	di, IOHELP_WRITE	; (DI) = function code.
	mov	dx, ds
	mov	ax, OFFSET DGROUP:DataBuf ; (DX:AX) = FWA, buffer to write.
	mov	cx, BUFSIZE		; (CX) = # bytes to write.
	call	dword ptr [IoHelper]	; (CX) = # bytes actually written.
	jc	Main_NoWrite		; if we couldn't write to the file.

;	We have written to the file, so close it now.

	mov	di, IOHELP_CLOSE	; (DI) = function code.
	call	dword ptr [IoHelper]	; close the file.
	jc	Main_NoClose		; if we couldn't close the file.

;	Now terminate the program, returning to Embedded DOS.

	mov	ah, DOSCONSTROUTPUT	; (AH) = output string function.
	mov	dx, OFFSET DGROUP:SuccessMsg
	int	21h

Main_Exit:
	mov	ah, DOSEXIT
	mov	al, 0			; successful status code.
	int	21h			; terminate program.

;	We were unable to create the file.

Main_NoCreate:
	mov	ah, DOSCONSTROUTPUT	; (AH) = output string function.
	mov	dx, OFFSET DGROUP:NoCreateMsg
	int	21h
	jmp	Main_Exit		; terminate the program.

;	We were unable to write to the file.

Main_NoWrite:
	mov	ah, DOSCONSTROUTPUT	; (AH) = output string function.
	mov	dx, OFFSET DGROUP:NoWriteMsg
	int	21h
	jmp	Main_Exit		; terminate the program.

;	We were unable to close the file.

Main_NoClose:
	mov	ah, DOSCONSTROUTPUT	; (AH) = output string function.
	mov	dx, OFFSET DGROUP:NoCloseMsg
	int	21h
	jmp	Main_Exit		; terminate the program.
EndProc Main

UCODE	ENDS
	END	Main
