	TITLE	EDOS - Embedded DOS kernel performance measurement test program.

;***	EDOS - Embedded DOS kernel performance measurement test program.
;
;1.	Functional Description.
;	This program measures how many context switches, timer operations,
;	event operations, mutex operations, and pool operations that can
;	be performed per second.
;
;2.	Modification History.
;	S. E. Jones	93/02/20.	Original.
;
;3.	NOTICE: Copyright (C) 1993 General Software.
;
;4.	Build Environment.
;	MASM 5.10, no special switches.

	include ..\inc\usegs.inc
	include ..\inc\udefines.inc
	include ..\inc\umacros.inc
	include ..\inc\ustruc.inc
	include ..\inc\kernel.inc

THIRTY_SECONDS_IN_TICKS = 546		; number of 55ms ticks in 30 seconds.


;	Define the stack.

_STACK	SEGMENT PARA STACK 'STACK'
	db	512 dup ('$')
TopStack =	$
_STACK	ENDS

UCODE	SEGMENT

OldIsr08	dd	?
TimerCount	dd	0		; number of timer start/stop ops.
EventCount	dd	0		; number of event clear/set ops.
MutexCount	dd	0		; number of mutex acquire/release ops.
CtxSwCount	dd	0		; number of context switches.
DosCallCount	dd	0		; number of DOS calls.
Counts		dd	?		; number of IRQ 0 interrupts.

;***	NewIsr8 - Clock Entrypoint.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is executed as an ISR for IRQ 0, the system clock tick.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	92/02/19.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	none.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc NewIsr8, PUBLIC, FAR
	add	Counts.lo, 1
	adc	Counts.hi, 0
	jmp	dword ptr cs:[OldIsr08] ; pass control to the BIOS.
EndProc NewIsr8

;***	TimerExpRtn - Timer Expiration Routine.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is a null routine to satisfy the allocate timer function.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	93/02/20.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	none.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc TimerExpRtn, FAR
EndProc TimerExpRtn

;***	TestTimers - Do Timer Loop.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine exercises the timer function and measures its performance.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	93/02/20.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	none.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc TestTimers
	PRINTF	<Timer test starting...\n>
	mov	Counts.hi, 0
	mov	Counts.lo, 0

	mov	dl, SYS_ALLOCATE_TIMER
	sub	ax, ax			; (AX) = context (meaningless).
	mov	bx, cs
	lea	cx, CGROUP:TimerExpRtn	; (BX:CX) = timer expiration routine.
	int	SYSINT			; (AX) = timer handle.
	jc	TestTimers_Exit         ; if failure.

	mov	Counts.hi, 0
	mov	Counts.lo, 0

TestTimers_Loop:
	mov	dl, SYS_START_TIMER
	mov	cx, 10000		; (CX) = 10,000ms, or 10 second delay.
	int	SYSINT

	mov	dl, SYS_STOP_TIMER
	int	SYSINT

	add	TimerCount.lo, 2
	adc	TimerCount.hi, 0	; count timer operations.

	cmp	Counts.lo, THIRTY_SECONDS_IN_TICKS
	jb	TestTimers_Loop

	mov	dl, SYS_DEALLOCATE_TIMER
	int	SYSINT

TestTimers_Exit:
	PRINTF	<Total 55ms ticks:  $lu.\n>, <Counts.hi, Counts.lo>
	PRINTF	<Timer Operations:  $lu.\n>, <TimerCount.hi, TimerCount.lo>
EndProc TestTimers

;***	TestEvents - Do Event Loop.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine exercises the event function and measures its performance.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	93/02/20.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	none.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc TestEvents
	PRINTF	<Event test starting...\n>
	mov	Counts.hi, 0
	mov	Counts.lo, 0

	mov	dl, SYS_ALLOCATE_EVENT
	int	SYSINT			; (AX) = event handle.
	jc	TestEvents_Exit         ; if failure.

	mov	Counts.hi, 0
	mov	Counts.lo, 0

TestEvents_Loop:
	mov	dl, SYS_SET_EVENT
	int	SYSINT

	mov	dl, SYS_CLEAR_EVENT
	int	SYSINT

	mov	dl, SYS_PULSE_EVENT
	int	SYSINT

	add	EventCount.lo, 3
	adc	EventCount.hi, 0	; count event operations.

	cmp	Counts.lo, THIRTY_SECONDS_IN_TICKS
	jb	TestEvents_Loop

	mov	dl, SYS_DEALLOCATE_EVENT
	int	SYSINT

TestEvents_Exit:
	PRINTF	<Total 55ms ticks:  $lu.\n>, <Counts.hi, Counts.lo>
	PRINTF	<Event Operations:  $lu.\n>, <EventCount.hi, EventCount.lo>
EndProc TestEvents

;***	TestMutexes - Do Mutex Loop.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine exercises the mutex function and measures its performance.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	93/02/20.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	none.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc TestMutexes
	PRINTF	<Mutex test starting...\n>
	mov	Counts.hi, 0
	mov	Counts.lo, 0

	mov	dl, SYS_ALLOCATE_MUTEX
	int	SYSINT			; (AX) = mutex handle.
	jc	TestMutexes_Exit	; if failure.

	mov	Counts.hi, 0
	mov	Counts.lo, 0

TestMutexes_Loop:
	mov	dl, SYS_ACQUIRE_MUTEX
	int	SYSINT

	mov	dl, SYS_RELEASE_MUTEX
	int	SYSINT

	add	MutexCount.lo, 2
	adc	MutexCount.hi, 0	; count mutex operations.

	cmp	Counts.lo, THIRTY_SECONDS_IN_TICKS
	jb	TestMutexes_Loop

	mov	dl, SYS_DEALLOCATE_MUTEX
	int	SYSINT

TestMutexes_Exit:
	PRINTF	<Total 55ms ticks:  $lu.\n>, <Counts.hi, Counts.lo>
	PRINTF	<Mutex Operations:  $lu.\n>, <MutexCount.hi, MutexCount.lo>
EndProc TestMutexes

;***	TestCtxSw - Do Context Switch Loop.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine exercises the ctxsw function and measures its performance.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	93/02/20.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	none.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc TestCtxSw
	PRINTF	<Context Switch test starting...\n>
	mov	Counts.hi, 0
	mov	Counts.lo, 0

	mov	dl, SYS_PASS_TIME_SLICE
TestCtxSw_Loop:
	int	SYSINT
	int	SYSINT
	int	SYSINT
	int	SYSINT
	int	SYSINT

	add	CtxSwCount.lo, 5
	adc	CtxSwCount.hi, 0	; count time slices.

	cmp	Counts.lo, THIRTY_SECONDS_IN_TICKS
	jb	TestCtxSw_Loop

TestCtxSw_Exit:
	PRINTF	<Total 55ms ticks:  $lu.\n>, <Counts.hi, Counts.lo>
	PRINTF	<CtxSw Operations:  $lu.\n>, <CtxSwCount.hi, CtxSwCount.lo>
EndProc TestCtxSw

;***	TestDosCall - Do DOS Call Loop.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine runs the INT 21h function and measures its performance.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	93/02/20.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	none.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc TestDosCall
	PRINTF	<DOS Call test starting...\n>
	mov	Counts.hi, 0
	mov	Counts.lo, 0

TestDosCall_Loop:
	mov	ah, 34h                 ; (AH) = get InDos flag function code.
	int	21h			; issue DOS call.
	mov	ah, 34h                 ; (AH) = get InDos flag function code.
	int	21h			; issue DOS call.
	mov	ah, 34h                 ; (AH) = get InDos flag function code.
	int	21h			; issue DOS call.
	mov	ah, 34h                 ; (AH) = get InDos flag function code.
	int	21h			; issue DOS call.
	mov	ah, 34h                 ; (AH) = get InDos flag function code.
	int	21h			; issue DOS call.

	add	DosCallCount.lo, 5
	adc	DosCallCount.hi, 0	; count DOS calls.

	cmp	Counts.lo, THIRTY_SECONDS_IN_TICKS
	jb	TestDosCall_Loop

TestDosCall_Exit:
	PRINTF	<Total 55ms ticks:  $lu.\n>, <Counts.hi, Counts.lo>
	PRINTF	<DOS Calls:         $lu.\n>, <DosCallCount.hi, DosCallCount.lo>
EndProc TestDosCall

;***	Main - Main Entrypoint.
;
;   FUNCTIONAL DESCRIPTION.
;	This routine is the entrypoint of the test program.  We print
;	a sign-on banner, and begin the loop we're testing.
;
;   MODIFICATION HISTORY.
;	S. E. Jones	92/02/19.	Original.
;
;   WARNINGS.
;	none.
;
;   ENTRY.
;	none.
;
;   EXIT.
;	none.
;
;   USES.
;	all.

	ASSUME	CS:CGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING
DefProc Main, PUBLIC, FAR
	mov	ax, DGROUP
	mov	ds, ax
	ASSUME	DS:DGROUP		; (DS) = DGROUP.
	PRINTF	<Embedded DOS kernel perf test, press any key to stop.\n>

;	Hook IRQ 0's vector so we can get control.

	sub	ax, ax
	mov	es, ax
	ASSUME	ES:NOTHING
	mov	ax, es:[08h*4+0]	; (AX) = offset portion of vector.
	mov	word ptr cs:[OldIsr08+0], ax ; save it.
	mov	ax, es:[08h*4+2]	; (AX) = segment portion of vector.
	mov	word ptr cs:[OldIsr08+2], ax ; save that, too.

	cli				; BEGIN HARD CRITICAL SECTION.
	mov	word ptr es:[08h*4+0], OFFSET CGROUP:NewIsr8
	mov	word ptr es:[08h*4+2], cs
	sti				; END HARD CRITICAL SECTION.

	Pcall	TestTimers
	Pcall	TestEvents
	Pcall	TestMutexes
	Pcall	TestCtxSw
	Pcall	TestDosCall

;	Restore old interrupt vector.

	sub	ax, ax
	mov	es, ax
	ASSUME	ES:NOTHING
	cli				; BEGIN HARD CRITICAL SECTION.
	mov	ax, word ptr cs:[OldIsr08+0] ; (AX) = saved offset of old vector.
	mov	es:[08h*4+0], ax	; restore it.
	mov	ax, word ptr cs:[OldIsr08+2] ; (AX) = saved segment portion of vector.
	mov	es:[08h*4+2], ax	; restore it, too.
	sti				; END HARD CRITICAL SECTION.

;	Now terminate the process and return to DOS.

	mov	ah, 4ch
	mov	al, 0			; successful status code.
	int	21h			; terminate program.
EndProc Main

UCODE	ENDS
	END	Main
