//***	CHELPER.H -- C Helper Routines for Debugging.
//
//1.	Functional Description.
//	This include file contains prototypes for the CHELPER library.
//
//2.	Modification History.
//	S. E. Jones	93/04/01.	#1.102, moved from KERNEL.ASM.
//	S. E. Jones	93/09/26.	#2.000, release.
//	S. E. Jones	95/01/24.	#2.2, release.
//
//3.	NOTICE: Copyright (C) 1991-1995 General Software, Inc.

#ifndef _CHELPER
#define _CHELPER

//
// This module depends on KTYPES.
//

#include "..\inc\ktypes.h"		// conditionally includes types.

//
// This API is provided for MSC users.	You MUST call this routine to
// cause the _chkstk routine to be stomped on with a RETF instruction.
// If you don't do this, then the runtime library will be making calls
// to this routine and the routine will abort the program with a "stack
// overflow" message, even though this is not the case.
//

VOID DisableStackChecking ();		// stomps on _chkstk routine.

//
// The following APi function is provided for all C language users to
// allow them to easily break into the Embedded DOS kernel debugger from
// their program.  This routine just executes an "INT 3" instruction.
//

VOID BreakPoint ();			// to allow for debugging.

#endif // not defined, _CHELPER
