;***	DDE.INC -- Embedded DOS Disk Directory Entry.
;
;1.	Functional Description.
;	This structure defines the layout of a FAT file system directory
;	entry as it is formatted on the disk.  This layout was derived
;	from the information in Ray Duncan's "Advanced MS-DOS" book, published
;	by Microsoft Press, page 149.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

DDE		struc
dde_filename	db	8 dup (?)	; first part of filename.
dde_ext         db	3 dup (?)	; second part of filename-- extension.
dde_flags	db	?		; attribute flags.
dde_reserved1	db	10 dup (?)	; reserved for future use (ours!).
dde_time	dw	?		; timestamp on file.
dde_date	dw	?		; datestamp on file.
dde_cluster	dw	?		; starting cluster number.
dde_size	dd	?		; file size in bytes.
DDE		ends

DDE_FLAGS_READONLY	=	01h	; file is read-only.
DDE_FLAGS_HIDDEN	=	02h	; file is excluded from normal searches.
DDE_FLAGS_SYSTEM	=	04h	; file is excluded from normal searches.
DDE_FLAGS_VOLUME_LABEL	=	08h	; this is a volume label entry.
DDE_FLAGS_DIRECTORY	=	10h	; this is a subdirectory.
DDE_FLAGS_ARCHIVE	=	20h	; file has been modified since last archive.
DDE_FLAGS_RESERVED1	=	40h	; reserved.
DDE_FLAGS_RESERVED2	=	80h	; reserved.
