//***	IOHELP.H -- Embedded DOS I/O Helper API Defs for C Language Programs.
//
//1.	Functional Description.
//	This include file contains prototypes for the Embedded DOS
//	I/O Helper API.
//
//2.	Modification History.
//	S. E. Jones	92/01/14.	#1.095, original.
//	S. E. Jones	93/09/26.	#2.000, release.
//	S. E. Jones	95/01/24.	#2.2, release.
//
//3.	NOTICE: Copyright (C) 1991-1995 General Software, Inc.

#ifndef _IOHELP
#define _IOHELP

//
// This module depends on KTYPES.
//

#include "..\inc\ktypes.h"		// conditionally includes types.

STATUS IoOpen(
    IN UCHAR *FileName,
    IN USHORT Flags,
    OUT HANDLE *Handle
    );

STATUS IoClose(
    IN HANDLE Handle
    );

STATUS IoCreate(
    IN UCHAR *FileName,
    IN USHORT IsDirectory,
    IN USHORT Flags,
    OUT HANDLE *Handle
    );

STATUS IoDelete(
    IN UCHAR *FileName,
    IN USHORT IsDirectory
    );

STATUS IoRead(
    IN HANDLE Handle,
    IN PVOID Buffer,
    IN USHORT BufferLength,
    OUT USHORT *BytesRead
    );

STATUS IoWrite(
    IN HANDLE Handle,
    IN PVOID Buffer,
    IN USHORT BufferLength,
    OUT USHORT *BytesWritten
    );

STATUS IoSeek(
    IN HANDLE Handle,
    IN ULONG Offset,
    IN USHORT Method,
    OUT ULONG *NewFilePointer
    );

STATUS IoRename(
    IN UCHAR *OldFileName,
    IN UCHAR *NewFileName
    );

STATUS IoFindFirst(
    IN UCHAR *FileName,
    IN PVOID OdeBuffer,
    IN USHORT SearchAttributesFlag,
    OUT HANDLE *Handle
    );

STATUS IoFindNext(
    IN HANDLE Handle,
    IN PVOID OdeBuffer
    );

STATUS IoFileControl(
    IN HANDLE Handle,
    IN PVOID Buffer,
    IN USHORT BufferLength,
    OUT USHORT *BytesReturned
    );

STATUS IoCommitFile(
    IN HANDLE Handle
    );

STATUS IoFileInfo(
    IN UCHAR *FileName,
    IN BOOLEAN IsSetOperation,
    IN USHORT NewAttributes,
    OUT USHORT *ReturnedAttributes
    );

STATUS IoFileTime(
    IN HANDLE Handle,
    IN BOOLEAN IsSetOperation,
    IN ULONG NewTimeStamp,
    OUT ULONG *ReturnedTimeStamp
    );

STATUS IoFsInfo(
    IN HANDLE Handle,
    OUT PVOID Buffer
    );

STATUS IoLock(
    IN HANDLE Handle,
    IN ULONG ByteOffset,
    IN ULONG Length
    );

STATUS IoUnlock(
    IN HANDLE Handle,
    IN ULONG ByteOffset,
    IN ULONG Length
    );

#endif // not defined, _IOHELP
