;***	MUTEX.INC -- Embedded DOS Mutex Object.
;
;1.	Functional Description.
;	The following structure defines a mutex object.  This object is
;	manipulated by the routines in MUTEX.ASM.  All mutex objects are
;	allocated from system pool, so they are all addressable in DOSDATA.
;	The MUTEX object is not visible to kernel components that use the
;	MUTEX object, but it is included here for the debugger.
;
;	Operations on mutexes are:
;	    AllocateMutex - Create mutex and initialize it to the released state.
;	    FreeMutex - Destroy mutex, destroying blocked threads.
;	    AcquireMutex - Acquire mutex for exclusive access.
;	    ReleaseMutex - Release exclusive access on mutex to another thread.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

MUTEX		struc
mutex_flags	dw	?		; current state of mutex.
MUTEX		ends

MUTEX_FLAGS_ACQUIRED =	0001h		; if set, mutex is acquired.
