;***	PPP.INC -- Embedded DOS Path Parsing Packet.
;
;1.	Functional Description.
;	This structure defines the layout of a block of memory that the
;	I/O system uses to parse filenames into.  These blocks are allocated
;	dynamically from the system pool as needed.  They are only used by
;	routines in IOSYS.ASM and IOHLP.ASM.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

PPP		struc
ppp_shte	dw	?		; local var for IoResolveObject.
ppp_handle	dw	?		; local var for IoResolveObject.
ppp_flags	dw	?		; parse flags, defined below.
ppp_drive	dw	?		; drive index.
ppp_sdte	dw	?		; FWA, SDTE for this parse.
ppp_devhdr	dd	?		; FWA, device driver header.

;	This buffer contains the parsed filename starting after any leading
;	'\\' for UNC names or '\\\' for DFS names.  All '/' characters have
;	been converted to '\' during the parse, and all blanks and non-ascii
;	characters (such as control characters, tabs, etc.) have been removed.
;	The buffer ends in a zero byte (ASCIIZ format).

ppp_path	db	MAX_PARSE_PATH_SIZE dup (?) ; canonicalized pathname.

;	The following pointer is set by IoCanonicalizeObjectName to point
;	to the character in the path buffer (above) that immediately follows
;	the prefix component.  This allows DosSetDir to obtain only the cwd
;	and user's relative path, and not the prefix string.  Note that this
;	field is not an index; it is a real offset pointer into ppp_path.

ppp_userpath	dw	?		; ofs FWA, 1st byte following prefix.

;	A temporary working buffer.

ppp_temp	db	MAX_PARSE_PATH_SIZE dup (?) ; temporary buffer.
PPP		ends

PPP_FLAGS_DRIVE =	0001h		; drive and SDTE are valid.
PPP_FLAGS_PATH	=	0002h		; path is valid.
PPP_FLAGS_UNC	=	0004h		; '\\' stripped off (UNC name).
PPP_FLAGS_DFS	=	0008h		; '\\\' stripped off; (DFS name).
PPP_FLAGS_EXPLICIT_DRIVE = 0010h	; if drive letter explicitly specified.
