;***	STE.INC -- Embedded DOS System Trace Entry.
;
;1.	Functional Description.
;	This structure defines the layout of a system trace entry.
;
;2.	Modification History.
;	S. E. Jones	92/11/02.	#1.101, original.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1992-1995 General Software, Inc.

STE		struc
ste_type	dw	?		; trace event type/this record.
ste_subtype	dw	?		; subtype, such as int #, etc.
ste_length	dw	?		; total bytes in this record.
ste_time0	dw	?		; least-significant 16-bits of timestamp.
ste_time1	dw	?		; next-least-significant 16-bits of t/s.
ste_time2	dw	?		; most-significant 16-bits of t/s.
ste_thread	dw	?		; handle to current thread.
ste_data	dw	?		; trace-defined data starts here.
STE		ends

ste_regs	EQU	ste_data	; copy of general registers (see CTX.INC).

STE_TYPE_NONE		=	0	; dummy event (no action).
STE_TYPE_HW_INT         =	1	; hardware interrupt.
STE_TYPE_SW_INT         =	2	; software interrupt.
STE_TYPE_SCHED		=	3	; system scheduler event (see subtype).
STE_TYPE_SYSCALL_ENTRY	=	4	; call to system function.
STE_TYPE_SYSCALL_EXIT	=	5	; returned system function.
STE_TYPE_INT21_ENTRY	=	6	; call to DOS INT 21h function.
STE_TYPE_INT21_EXIT	=	7	; returned DOS INT 21h function.
