/*=======================================================================
=                           INCLUDE FILES                               =
=======================================================================*/

#include    <stdlib.h>
#include    <mem.h>
#include    <stdio.h>
#include 	<dos.h>
#include 	"mvidf1hs.h"
#include 	"ktypes.h"
#include    "system.h"
#include    "kernel.h"
/*=======================================================================
=                       MAIN ENTRY POINT                                =
=======================================================================*/

/************************************************************************
*
*     Entry point:                                                      
*       main                                           
*
*     Description:                                                      
*		This is a sample program for the Half-Duplex Slave DF1 API.  This 
*		program performs the following functions:
*			1. Fetches and displays the series and revision number of
*				the half-duplex slave DF1 API. 
*			2. Opens a half-duplex slave DF1 engine on Port 3
*			3. Monitors for an incoming master command packet
*			4. Verifies reception of the ECHO command
*			5. Transmits a response packet to the ECHO command
*			6. Verifies transmission of the response packet.
*			7. Closes the half-duplex slave DF1 engine running on Port 3.  
*     Arguments:                                                        
*       none
*
*     External effects:                                                 
*
*
*     Return value:                                                     
*       none
*
************************************************************************/
void main(void)
{
HDSCFG Port3Cfg;           		// Allocate data for port 3	DF1 configuration
BYTE DF1_Pkt[256];
BYTE DF1_Source_Pkt[256];
WORD Pkt_Len;
WORD Xmit_Len;
char i;
char x;
char terminate;
SRCXMT DF1_Stat;
int rc;
#define DLE 0x10

	Port3Cfg.Baud = BAUD_9600;
	Port3Cfg.Parity = PARITY_NONE;
	Port3Cfg.Stop = STOPBITS1;
	Port3Cfg.DupPacket = DUP_PACKET_DIS;
	Port3Cfg.ErrorDet = CRC_ERROR_CHK;
	Port3Cfg.Station = 0x12;
	Port3Cfg.MsgRetries = 0x03;
	Port3Cfg.Handshake = HSHAKE_NONE;
	Port3Cfg.RTSSend = 70;
	Port3Cfg.RTSOff = 40;
	Port3Cfg.ComPort = COM3;
	rc = MVIdf1_HDSOpenPort(&Port3Cfg);
	if(rc == MVI_SUCCESS)
	{
		terminate = 0x00;			
    	printf("\nPort opened successfully\n");
		printf("\nWaiting for command\n");
		while(terminate == 0x00)
		{
			if(MVI_SUCCESS == (MVIdf1_HDSGetPkt(COM3,DF1_Pkt,&Pkt_Len)))
			{
				printf("\nCommand packet retrieved successfully\n");
				i = 0x00;
				x = 0x04;					// Set index to point to 1st byte of TNS
				Xmit_Len = 0x00;
				if(DF1_Pkt[02] == 0x06)		// Is this the ECHO command ?
				{			  
					DF1_Source_Pkt[i++] = DF1_Pkt[1];	// Set DST value
					DF1_Source_Pkt[i++] = DF1_Pkt[0];	// Set SRC value
					DF1_Source_Pkt[i++] = 0x46;			// Set CMD value
					DF1_Source_Pkt[i++] = 0x00;			// Set STS value
					DF1_Source_Pkt[i++] = DF1_Pkt[x++];	// Fetch data and store
					while(x < Pkt_Len)					// Return data for echo command
					{
						if(DF1_Pkt[x] == DLE)				
						{
							DF1_Source_Pkt[i++] = DF1_Pkt[x++];
							Xmit_Len++;
							DF1_Source_Pkt[i++] = DF1_Pkt[x++];
							Xmit_Len++;
							if(DF1_Pkt[x] == DLE)
							{
								DF1_Source_Pkt[i++] = DF1_Pkt[x++];
								Xmit_Len++;
							}
						}
						else
						{
							DF1_Source_Pkt[i++] = DF1_Pkt[x++];
							Xmit_Len++;
							if(DF1_Pkt[x] == DLE)
							{
								DF1_Source_Pkt[i++] = DF1_Pkt[x++];
								Xmit_Len++;
							}
						}
					}
					Xmit_Len = Xmit_Len + 0x06;
					if(MVI_SUCCESS == (MVIdf1_HDSPutPkt(COM3,DF1_Source_Pkt,&Xmit_Len)))
					{
						printf("\nResponse packet queued for transmission\n");
						printf("\nMonitoring transmission status\n");
						while(MVI_ERR_NOSTAT == MVIdf1_HDSGetPktStat(COM3,&DF1_Stat))
						{};
						while(MVIDF1_XMITTING == DF1_Stat.XmitStatus)
						{
							if(MVI_SUCCESS != MVIdf1_HDSGetPktStat(COM3,&DF1_Stat))
							{					// Status retrieval failed
								printf("\nPacket status retrieval error !\n");
											// Force exit
								DF1_Stat.XmitStatus = MVIDF1_FAILED;
							}
						}
						if(DF1_Stat.XmitStatus == MVIDF1_SUCCESS)
						{
							printf("\nPacket transmission successful\n");
						}
						else
						{
							printf("\nPacket transmission failed\n");
						}	 
					}
				}
				else
				{
					printf("\nUnknown command\n");
				}
				terminate = 0xFF;	
			}
		}	   
	}
	else
	{
		if(rc == MVI_ERR_REOPEN)
		{
    		printf("\nPort already open\n");
		}
		else
		{
   			printf("\nPort number invalid\n");
		}
	}		
	rc = MVIdf1_HDSClosePort(COM3);	// Terminate the thread
	if(rc == MVI_SUCCESS)
	{
    	printf("\nPort closed successfully\n");
	}
	else
	{
		if(rc == MVI_ERR_NOACCESS)
		{
    		printf("\nPort already closed\n");
		}
		else
		{
   			printf("\nPort number invalid\n");
		}
	}		
	exit(0);
}
