;***	SHTE.INC -- Embedded DOS System Handle Table Entry.
;
;1.	Functional Description.
;	This structure defines the layout of an entry in the system
;	handle table, a fixed-length (256-element) array allocated
;	at SYSINIT time.  When I/O operations are requested by application
;	programs through INT 21h, the application handle is used as an
;	index into the psp_filetbl[] array, and the byte at that location
;	is the SHT index which is used to get the address of the SHTE
;	which governs Embedded DOS's operations on that handle.
;
;2.	Modification History.
;	S. E. Jones	90/11/09.	OEM DOS Release for COMDEX.
;	S. E. Jones	93/09/26.	#2.000, release.
;	S. E. Jones	95/01/24.	#2.2, release.
;
;3.	NOTICE: Copyright (C) 1990-1995 General Software, Inc.

SHTE_SIGNATURE	=	4321h		; if ==, this is an SHTE.

SHTE		struc
shte_sig	dw	?		; SHTE signature.
shte_object	dw	?		; object type.
shte_flags	dw	?		; flags, described below.
shte_handle	dw	?		; internal ID maintained by FSD.
shte_dev	dd	?		; FWA, device driver header.
shte_fsd	dw	?		; seg adr, FSD driver.
shte_sdte	dw	?		; offset ptr, SDTE if FSD covered drive.
shte_refcount	dw	?		; number of open refs/this SHTE.
SHTE		ends

SHTE_OBJECT_INV =	0		; handle not completely defined.
SHTE_OBJECT_FSD =	1		; handle opened to FSD-managed object.
SHTE_OBJECT_DEV =	2		; handle opened to device-managed obj.

SHTE_FLAGS_FSDDEFINED = 0001h		; FSD field is meaningful.
SHTE_FLAGS_DEVDEFINED = 0002h		; DEV field is meaningful.
SHTE_FLAGS_LOCKED     = 0004h		; SHTE is locked. read/write not permitted.
SHTE_FLAGS_RESERVED   = 0008h		; this flag is unused.
SHTE_FLAGS_INHERIT    = 0010h		; SHTE is inheritable.

;	The following bogus flags are used by DosDevIoctl get/set device
;	information requests.  Sorry for the silliness, but programs actually
;	use this stuff.

SHTE_FLAGS_RAW	      = 0020h		; handle is "raw", otherwise cooked.
SHTE_FLAGS_EOF	      = 0040h		; handle is at EOF on input.
SHTE_FLAGS_WRITTEN    = 0080h		; set if file has been written to.

;	The following flags are used to keep track of device capabilities
;	for open and close functions.

SHTE_FLAGS_OPENCLOSE  = 0100h		; device driver supports open & close.
SHTE_FLAGS_CHAR       = 0200h		; device driver implements a character device.

;	Here are some more miscellaneous flags required for IOCTL.

SHTE_FLAGS_NETWORK    = 0400h		; this handle is remote (DFS or UNC).

;	Here is more bogusness associated with "cooked" and "raw" I/O.
;	If an SHTE for a device is cooked and has the CONSOLE bit set,
;	then IOCON.ASM routines are used to handle the cooked I/O instead
;	of IoRead/IoWrite in IOSYS.ASM.

SHTE_FLAGS_CONSOLE    = 0800h		; this char driver is attached to the console.
